/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.advanced;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.database.data.Throticle;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDestinations;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetHomeLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.flight.DematerialiseToVortex;
import me.eccentric_nz.TARDIS.flight.MaterialseFromVortex;
import me.eccentric_nz.TARDIS.flight.TARDISHandbrake;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.travel.TARDISEPSRunnable;
import me.eccentric_nz.TARDIS.travel.TravelCostAndType;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AuthorisedControlDisk {
    private final TARDIS plugin;
    private final UUID uuid;
    private final List<Component> lore;
    private final int id;
    private final Player player;
    private final String eps;
    private final String creeper;

    AuthorisedControlDisk(TARDIS plugin, UUID uuid, List<Component> lore, int id, Player player, String eps, String creeper) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.lore = lore;
        this.id = id;
        this.player = player;
        this.eps = eps;
        this.creeper = creeper;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String process() {
        List<UUID> playerUUIDs;
        Player timelord = this.plugin.getServer().getPlayer(this.uuid);
        if (timelord == null || !timelord.isOnline()) {
            return "The Time Lord of this TARDIS is not online.";
        }
        Location location = null;
        COMPASS direction = COMPASS.EAST;
        boolean isPlayerLocation = false;
        TravelType travelType = TravelType.SAVE;
        if (this.lore.size() > 3) {
            String save = ComponentUtils.stripColour(this.lore.get(3));
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", this.id);
            if (save.equals("Home")) {
                ResultSetHomeLocation rsh = new ResultSetHomeLocation(this.plugin, where);
                if (!rsh.resultSet()) return "Could not find the TARDIS's home location.";
                location = new Location(rsh.getWorld(), (double)rsh.getX(), (double)rsh.getY(), (double)rsh.getZ());
                direction = rsh.getDirection();
                travelType = TravelType.HOME;
            } else {
                ResultSetDestinations rsd = new ResultSetDestinations(this.plugin, where, false);
                if (rsd.resultSet()) {
                    World w = TARDISAliasResolver.getWorldFromAlias(rsd.getWorld());
                    if (w == null) return "Could not find the specified TARDIS save.";
                    location = new Location(w, (double)rsd.getX(), (double)rsd.getY(), (double)rsd.getZ());
                    direction = COMPASS.valueOf(rsd.getDirection());
                }
            }
        } else {
            location = timelord.getLocation();
            isPlayerLocation = true;
            travelType = TravelType.PLAYER;
        }
        if (location == null) return "success";
        if (isPlayerLocation) {
            if (this.plugin.getUtils().inTARDISWorld(timelord)) {
                return "The Time Lord must be outside the TARDIS.";
            }
            if (!this.plugin.getPluginRespect().getRespect(location, new Parameters(timelord, Flag.getNoMessageFlags()))) {
                return "The Time Lord's location does not allow travel.";
            }
        }
        HashMap<String, Object> wheren = new HashMap<String, Object>();
        wheren.put("tardis_id", this.id);
        HashMap<String, Object> setn = new HashMap<String, Object>();
        setn.put("world", location.getWorld().getName());
        setn.put("x", location.getBlockX());
        setn.put("y", location.getBlockY());
        setn.put("z", location.getBlockZ());
        setn.put("direction", direction.toString());
        setn.put("submarine", 0);
        this.plugin.getQueryFactory().doUpdate("next", setn, wheren);
        this.plugin.getTrackerKeeper().getHasDestination().put(this.id, new TravelCostAndType(this.plugin.getArtronConfig().getInt("travel"), travelType));
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", this.id);
        where.put("type", 0);
        where.put("secondary", 0);
        ResultSetControls rsc = new ResultSetControls(this.plugin, where, false);
        if (!rsc.resultSet()) return "Could not disengage handbrake.";
        Location handbrake = TARDISStaticLocationGetters.getLocationFromBukkitString(rsc.getLocation());
        TARDISHandbrake.setLevers(handbrake.getBlock(), false, true, handbrake.toString(), this.id, this.plugin);
        if (this.plugin.getConfig().getBoolean("circuits.damage")) {
            this.plugin.getTrackerKeeper().getHasNotClickedHandbrake().remove(this.id);
        }
        TARDISSounds.playTARDISSound(handbrake, "tardis_handbrake_release");
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("handbrake_on", 0);
        HashMap<String, Object> whereh = new HashMap<String, Object>();
        whereh.put("tardis_id", this.id);
        this.plugin.getQueryFactory().doUpdate("tardis", set, whereh);
        this.plugin.getMessenger().sendStatus(this.player, "HANDBRAKE_OFF");
        this.plugin.getTrackerKeeper().getInVortex().add(this.id);
        HashMap<String, Object> wherev = new HashMap<String, Object>();
        wherev.put("tardis_id", this.id);
        ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wherev, true);
        if (rst.resultSet()) {
            playerUUIDs = rst.getData();
        } else {
            playerUUIDs = new ArrayList<UUID>();
            playerUUIDs.add(this.player.getUniqueId());
        }
        String message = "The TARDIS has detected an authorised control disc, valid for one journey only. Travelling to the programmed location.";
        TARDISEPSRunnable EPS_runnable = new TARDISEPSRunnable(this.plugin, message, this.player, playerUUIDs, this.id, this.eps, this.creeper);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)EPS_runnable, 20L);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            Throticle throticle = new Throticle(SpaceTimeThrottle.NORMAL, false);
            new DematerialiseToVortex(this.plugin, this.id, this.player, handbrake, throticle).run();
            new MaterialseFromVortex(this.plugin, this.id, this.player, handbrake, throticle).run();
        }, 60L);
        return "success";
    }
}

