/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.ARS.relocator;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.ARS.ARS;
import me.eccentric_nz.TARDIS.ARS.ARSMapData;
import me.eccentric_nz.TARDIS.ARS.ARSMethods;
import me.eccentric_nz.TARDIS.ARS.ARSProcessor;
import me.eccentric_nz.TARDIS.ARS.ARSRunnable;
import me.eccentric_nz.TARDIS.ARS.ARSSaveData;
import me.eccentric_nz.TARDIS.ARS.GrowSlot;
import me.eccentric_nz.TARDIS.ARS.JettisonRunnable;
import me.eccentric_nz.TARDIS.ARS.JettisonSlot;
import me.eccentric_nz.TARDIS.ARS.TARDISARS;
import me.eccentric_nz.TARDIS.ARS.relocator.RoomBlockScanner;
import me.eccentric_nz.TARDIS.ARS.relocator.RoomRelocatorInventory;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.DamageUtility;
import me.eccentric_nz.TARDIS.commands.sudo.TARDISSudoTracker;
import me.eccentric_nz.TARDIS.desktop.BlockScannerData;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.rooms.RoomRequiredLister;
import me.eccentric_nz.TARDIS.schematic.SchematicGZip;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Breedable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class RoomRelocatorListener
extends ARSMethods
implements Listener {
    public final HashMap<UUID, Integer> relocation_slot = new HashMap();
    public final HashMap<UUID, ItemStack> level_switch = new HashMap();

    public RoomRelocatorListener(TARDIS plugin) {
        super(plugin);
    }

    @EventHandler(ignoreCancelled=true)
    public void onRoomRelocatorClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof RoomRelocatorInventory)) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        UUID playerUUID = player.getUniqueId();
        UUID uuid = TARDISSudoTracker.SUDOERS.getOrDefault(playerUUID, playerUUID);
        this.ids.put(playerUUID, this.getTardisId(uuid.toString()));
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 53) {
            return;
        }
        if (slot != 3 && slot != 10 && !this.hasLoadedMap.contains(playerUUID)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARS_LOAD");
            return;
        }
        InventoryView view = event.getView();
        switch (slot) {
            case 1: 
            case 9: 
            case 11: 
            case 19: {
                this.moveMap(playerUUID, view, slot);
                break;
            }
            case 3: {
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.openInventory(new RoomRelocatorInventory(this.plugin, player).getInventory()), 2L);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                if (this.isGravity(view, slot)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "RELOCATOR_GRAVITY");
                    return;
                }
                if (!this.checkSlotForConsole(view, slot) && !this.level_switch.containsKey(playerUUID)) {
                    this.setFromSlot(view, uuid, slot);
                    break;
                }
                if (!this.relocation_slot.containsKey(playerUUID) && this.level_switch.containsKey(playerUUID) && this.isEmptySlot(view, slot)) {
                    this.relocation_slot.put(playerUUID, slot);
                    this.setRelocationSlot(view, playerUUID);
                    break;
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "RELOCATOR_RESET");
                break;
            }
            case 10: {
                this.loadMap(view, playerUUID, true);
                break;
            }
            case 12: {
                if (!this.level_switch.containsKey(playerUUID) || !this.relocation_slot.containsKey(playerUUID)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "RELOCATOR_SELECT");
                    return;
                }
                if (!this.plugin.getBuildKeeper().getRoomProgress().containsKey(player.getUniqueId())) {
                    this.relocate(player, view, this.relocation_slot.get(playerUUID));
                    break;
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARS_ACTIVE");
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                if (this.map_data.containsKey(playerUUID)) {
                    this.switchLevel(view, slot, playerUUID);
                    ARSMapData md = (ARSMapData)this.map_data.get(playerUUID);
                    this.setMap(md.getY(), md.getE(), md.getS(), playerUUID, view);
                    this.setLore(view, slot, null);
                    break;
                }
                this.setLore(view, slot, this.plugin.getLanguage().getString("ARS_LOAD", "You need to load the map first!"));
                break;
            }
            case 30: {
                this.level_switch.remove(playerUUID);
                this.relocation_slot.remove(playerUUID);
                this.level_switch.remove(uuid);
                this.loadMap(view, playerUUID, false);
                break;
            }
        }
    }

    private boolean isGravity(InventoryView view, int slot) {
        ItemStack is = view.getItem(slot);
        return is != null && (is.getType() == Material.SANDSTONE || is.getType() == Material.MOSSY_COBBLESTONE);
    }

    private void relocate(Player player, InventoryView view, int slot) {
        UUID playerUUID = player.getUniqueId();
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            this.level_switch.remove(playerUUID);
            this.relocation_slot.remove(playerUUID);
            this.hasLoadedMap.remove(playerUUID);
            if (this.map_data.containsKey(playerUUID)) {
                if (this.playerIsOwner(playerUUID, (Integer)this.ids.get(playerUUID))) {
                    this.saveAll(playerUUID);
                    ARSProcessor tap = new ARSProcessor(this.plugin, (Integer)this.ids.get(playerUUID));
                    boolean changed = tap.compare3DArray(((ARSSaveData)this.save_map_data.get(playerUUID)).getData(), ((ARSMapData)this.map_data.get(playerUUID)).getData());
                    if (changed && tap.checkCosts(tap.getChanged(), tap.getJettison())) {
                        RoomBlockScanner brs;
                        BlockScannerData check;
                        Map.Entry<JettisonSlot, ARS> entry = tap.getJettison().entrySet().iterator().next();
                        JettisonSlot jettison = entry.getKey();
                        String room = this.getRoomName(view, slot);
                        if (this.plugin.getConfig().getBoolean("growth.rooms_require_blocks")) {
                            if (!TARDISSudoTracker.SUDOERS.containsKey(playerUUID) && !this.hasCondensables(playerUUID.toString(), tap.getChanged(), (Integer)this.ids.get(playerUUID))) {
                                String message = tap.getChanged().size() > 1 ? "ARS_CONDENSE_MULTIPLE" : "ARS_CONDENSE";
                                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, message);
                                if (tap.getChanged().size() == 1) {
                                    RoomRequiredLister.listCondensables(this.plugin, tap.getChanged().entrySet().iterator().next().getValue().toString(), player);
                                }
                                this.revert(playerUUID);
                                player.closeInventory();
                                return;
                            }
                        } else if (!room.isEmpty() && !(check = (brs = new RoomBlockScanner(this.plugin, room, jettison, playerUUID)).check()).allow()) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "RELOCATOR_PERCENT_BLOCKS", "" + this.plugin.getConfig().getInt("desktop.block_change_percent"));
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "UPGRADE_PERCENT_EXPLAIN", "" + check.count(), "" + check.volume(), "" + check.changed());
                            return;
                        }
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARS_START");
                        Map.Entry<GrowSlot, ARS> ars = tap.getChanged().entrySet().iterator().next();
                        GrowSlot relocated = ars.getKey();
                        ARSRunnable ar = new ARSRunnable(this.plugin, relocated, ars.getValue(), player, (Integer)this.ids.get(playerUUID));
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)ar, 20L);
                        int sy = jettison.getY();
                        int sx = jettison.getX();
                        int sz = jettison.getZ();
                        World world = jettison.getChunk().getWorld();
                        int sy_offset = sy + Math.abs(this.plugin.getRoomsConfig().getInt("rooms." + room + ".offset")) + 1;
                        Block westDoor = world.getBlockAt(sx, sy_offset, sz + 8);
                        Block northDoor = world.getBlockAt(sx + 8, sy_offset, sz);
                        Block eastDoor = world.getBlockAt(sx + 15, sy_offset, sz + 8);
                        Block southDoor = world.getBlockAt(sx + 8, sy_offset, sz + 15);
                        westDoor.setType(Material.REINFORCED_DEEPSLATE);
                        northDoor.setType(Material.REINFORCED_DEEPSLATE);
                        eastDoor.setType(Material.REINFORCED_DEEPSLATE);
                        southDoor.setType(Material.REINFORCED_DEEPSLATE);
                        westDoor.getRelative(BlockFace.UP).setType(Material.REINFORCED_DEEPSLATE);
                        northDoor.getRelative(BlockFace.UP).setType(Material.REINFORCED_DEEPSLATE);
                        eastDoor.getRelative(BlockFace.UP).setType(Material.REINFORCED_DEEPSLATE);
                        southDoor.getRelative(BlockFace.UP).setType(Material.REINFORCED_DEEPSLATE);
                        HashMap<Breedable, Location> mobs = new HashMap<Breedable, Location>();
                        Chunk roomChunk = world.getBlockAt(sx, sy, sz).getChunk();
                        for (Entity entity : roomChunk.getEntities()) {
                            if (!(entity instanceof Breedable)) continue;
                            Breedable animal = (Breedable)entity;
                            mobs.put(animal, animal.getLocation());
                        }
                        int ey = relocated.getY();
                        int ex = relocated.getX();
                        int ez = relocated.getZ();
                        int dy = ey - sy;
                        int dx = ex - sx;
                        int dz = ez - sz;
                        int height = this.getSchematicHeight(room);
                        long a_long_time = (long)(256 * height) * Math.round(20.0 / this.plugin.getConfig().getDouble("growth.room_speed"));
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                            for (Map.Entry e : mobs.entrySet()) {
                                Location tp = ((Location)e.getValue()).add((double)dx, (double)dy, (double)dz);
                                ((Entity)e.getKey()).teleport(tp);
                            }
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ROOM_JETT", String.format("%d", tap.getJettison().size()));
                        }, a_long_time);
                        JettisonRunnable jr = new JettisonRunnable(this.plugin, jettison, entry.getValue(), (Integer)this.ids.get(playerUUID), player, true);
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)jr, a_long_time + 50L);
                        DamageUtility.run(this.plugin, DiskCircuit.ARS, this.plugin.getTardisAPI().getIdOfTARDISPlayerIsIn(playerUUID), player);
                    } else {
                        this.revert(playerUUID);
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, tap.getError());
                    }
                } else {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ROOM_ONLY_TL");
                    this.revert(playerUUID);
                }
                this.map_data.remove(playerUUID);
                this.save_map_data.remove(playerUUID);
                this.ids.remove(playerUUID);
            }
            player.closeInventory();
        }, 1L);
    }

    private int getSchematicHeight(String room) {
        JsonObject obj = SchematicGZip.getObject(this.plugin, "rooms", room.toLowerCase(Locale.ROOT), false);
        if (obj == null) {
            return 16;
        }
        JsonObject dimensions = obj.get("dimensions").getAsJsonObject();
        return dimensions.get("height").getAsInt();
    }

    private String getRoomName(InventoryView view, int slot) {
        ItemStack is = view.getItem(slot);
        if (is != null) {
            ItemMeta im = is.getItemMeta();
            String name = ComponentUtils.stripColour(im.displayName());
            for (TARDISARS ars : TARDISARS.values()) {
                if (!name.equals(ars.getDescriptiveName())) continue;
                return ars.toString();
            }
        }
        return "";
    }

    private void setRelocationSlot(InventoryView view, UUID uuid) {
        int to_slot = this.relocation_slot.get(uuid);
        ItemStack is = this.level_switch.get(uuid).clone();
        ItemMeta im = is.getItemMeta();
        im.setEnchantmentGlintOverride(Boolean.valueOf(true));
        is.setItemMeta(im);
        this.setSlot(view, to_slot, is, uuid, true);
    }

    private void setFromSlot(InventoryView view, UUID uuid, int slot) {
        this.level_switch.put(uuid, view.getItem(slot));
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            ItemStack tnt = ItemStack.of((Material)Material.TNT, (int)1);
            ItemMeta j = tnt.getItemMeta();
            j.displayName((Component)Component.text((String)"Jettison"));
            tnt.setItemMeta(j);
            this.setSlot(view, slot, tnt, uuid, true);
        }, 2L);
    }

    private boolean isEmptySlot(InventoryView view, int slot) {
        ItemStack is = view.getItem(slot);
        return is != null && is.getType() == Material.STONE;
    }
}

