/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.monsters.racnoss;

import java.util.Collection;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngelSpawnEvent;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.equip.Equipper;
import me.eccentric_nz.tardisweepingangels.nms.MonsterSpawner;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import me.eccentric_nz.tardisweepingangels.utils.WorldGuardChecker;
import me.eccentric_nz.tardisweepingangels.utils.WorldProcessor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.PiglinBrute;
import org.bukkit.event.Event;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class RacnossRunnable
implements Runnable {
    private final TARDIS plugin;
    private final int spawn_rate;
    private final List<Material> goodNether = List.of(Material.NETHERRACK, Material.SOUL_SAND, Material.GLOWSTONE, Material.NETHER_BRICK, Material.NETHER_BRICK_FENCE, Material.NETHER_BRICK_STAIRS);

    public RacnossRunnable(TARDIS plugin) {
        this.plugin = plugin;
        this.spawn_rate = plugin.getMonstersConfig().getInt("spawn_rate.how_many");
    }

    @Override
    public void run() {
        this.plugin.getServer().getWorlds().forEach(w -> {
            String name = WorldProcessor.sanitiseName(w.getName());
            if (this.plugin.getMonstersConfig().getInt("racnoss.worlds." + name) > 0) {
                if (w.getEnvironment() != World.Environment.NETHER) {
                    this.plugin.debug("Tried to spawn Racnoss in non-Nether world, please remove " + w.getName() + " from the racnoss worlds configuration!");
                    return;
                }
                int racnoss = 0;
                Collection brutes = w.getEntitiesByClass(PiglinBrute.class);
                for (PiglinBrute b : brutes) {
                    PersistentDataContainer pdc = b.getPersistentDataContainer();
                    if (!pdc.has(TARDISWeepingAngels.RACNOSS, PersistentDataType.INTEGER)) continue;
                    ++racnoss;
                }
                if (racnoss < this.plugin.getMonstersConfig().getInt("racnoss.worlds." + name)) {
                    for (int i = 0; i < this.spawn_rate; ++i) {
                        this.spawnRacnoss((World)w);
                    }
                }
            }
        });
    }

    private void spawnRacnoss(World world) {
        int players = world.getPlayers().size();
        if (players == 0) {
            return;
        }
        Chunk[] chunks = world.getLoadedChunks();
        if (chunks.length > 0) {
            Chunk chunk = chunks[TARDISConstants.RANDOM.nextInt(chunks.length)];
            int x = chunk.getX() * 16 + TARDISConstants.RANDOM.nextInt(16);
            int z = chunk.getZ() * 16 + TARDISConstants.RANDOM.nextInt(16);
            int y = this.getHighestNetherBlock(world, x, z);
            Location l = new Location(world, (double)x, (double)(y + 1), (double)z);
            if (this.plugin.isWorldGuardOnServer() && !WorldGuardChecker.canSpawn(l)) {
                return;
            }
            LivingEntity racnoss = new MonsterSpawner().create(l, Monster.RACNOSS);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                new Equipper(Monster.RACNOSS, racnoss, false).setHelmetAndInvisibility();
                this.plugin.getServer().getPluginManager().callEvent((Event)new TARDISWeepingAngelSpawnEvent((Entity)racnoss, EntityType.PIGLIN_BRUTE, Monster.RACNOSS, l));
            }, 5L);
        }
    }

    private int getHighestNetherBlock(World w, int wherex, int wherez) {
        int y = 100;
        Block startBlock = w.getBlockAt(wherex, y, wherez);
        while (!startBlock.getType().isAir()) {
            startBlock = startBlock.getRelative(BlockFace.DOWN);
        }
        int air = 0;
        while (startBlock.getType().isAir() && startBlock.getLocation().getBlockY() > 30) {
            startBlock = startBlock.getRelative(BlockFace.DOWN);
            ++air;
        }
        Material mat = startBlock.getType();
        if (air >= 5 && this.goodNether.contains(mat)) {
            y = startBlock.getLocation().getBlockY() + 1;
        }
        return y;
    }
}

