/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.commands;

import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.custommodels.keys.DalekVariant;
import me.eccentric_nz.TARDIS.database.data.Follower;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngelSpawnEvent;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.equip.Equipper;
import me.eccentric_nz.tardisweepingangels.monsters.daleks.DalekEquipment;
import me.eccentric_nz.tardisweepingangels.monsters.empty_child.EmptyChildEquipment;
import me.eccentric_nz.tardisweepingangels.monsters.headless_monks.HeadlessFlameRunnable;
import me.eccentric_nz.tardisweepingangels.monsters.headless_monks.HeadlessMonkEquipment;
import me.eccentric_nz.tardisweepingangels.monsters.judoon.JudoonEquipment;
import me.eccentric_nz.tardisweepingangels.monsters.k9.K9Equipment;
import me.eccentric_nz.tardisweepingangels.monsters.ood.OodEquipment;
import me.eccentric_nz.tardisweepingangels.monsters.silent.SilentEquipment;
import me.eccentric_nz.tardisweepingangels.monsters.toclafane.ToclafaneEquipment;
import me.eccentric_nz.tardisweepingangels.nms.MonsterSpawner;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import net.kyori.adventure.text.Component;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SpawnCommand {
    private final TARDIS plugin;

    public SpawnCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean spawn(CommandSender sender, String[] args) {
        Monster monster;
        if (args.length < 2) {
            return false;
        }
        String upper = args[1].toUpperCase(Locale.ROOT);
        try {
            monster = Monster.valueOf(upper);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getMessenger().send(sender, TardisModule.MONSTERS, "WA_INVALID");
            return true;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (!TARDISPermission.hasPermission(player, "tardisweepingangels.spawn." + monster.getPermission())) {
                this.plugin.getMessenger().send(sender, TardisModule.MONSTERS, "WA_PERM_SPAWN", monster.toString());
                return true;
            }
            Location eyeLocation = player.getTargetBlock(null, 50).getLocation();
            eyeLocation.add(0.5, 1.25, 0.5);
            eyeLocation.setYaw(player.getLocation().getYaw() - 180.0f);
            LivingEntity a = monster.isFollower() ? (LivingEntity)new MonsterSpawner().createFollower(eyeLocation, new Follower(UUID.randomUUID(), player.getUniqueId(), monster)).getBukkitEntity() : new MonsterSpawner().create(eyeLocation, monster);
            a.setNoDamageTicks(75);
            switch (monster) {
                case DALEK: {
                    DalekEquipment.set(a, false);
                    if (args.length <= 2) break;
                    if (args[2].equalsIgnoreCase("flying")) {
                        EntityEquipment ee = a.getEquipment();
                        ee.setChestplate(ItemStack.of((Material)Material.ELYTRA, (int)1));
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                            a.teleport(a.getLocation().add(0.0, 20.0, 0.0));
                            a.setGliding(true);
                        }, 2L);
                        break;
                    }
                    try {
                        DyeColor colour = DyeColor.valueOf((String)args[2].toUpperCase(Locale.ROOT));
                        NamespacedKey head = DalekVariant.DALEK_BRASS.getKey();
                        switch (colour) {
                            case BLACK: {
                                head = DalekVariant.DALEK_BLACK.getKey();
                                break;
                            }
                            case WHITE: {
                                head = DalekVariant.DALEK_WHITE.getKey();
                                break;
                            }
                            case RED: {
                                head = DalekVariant.DALEK_RED.getKey();
                                break;
                            }
                            case BROWN: {
                                head = DalekVariant.DALEK_BROWN.getKey();
                                break;
                            }
                            case GREEN: {
                                head = DalekVariant.DALEK_GREEN.getKey();
                                break;
                            }
                            case BLUE: {
                                head = DalekVariant.DALEK_BLUE.getKey();
                                break;
                            }
                            case PURPLE: {
                                head = DalekVariant.DALEK_PURPLE.getKey();
                                break;
                            }
                            case CYAN: {
                                head = DalekVariant.DALEK_CYAN.getKey();
                                break;
                            }
                            case LIGHT_GRAY: {
                                head = DalekVariant.DALEK_LIGHT_GRAY.getKey();
                                break;
                            }
                            case GRAY: {
                                head = DalekVariant.DALEK_GRAY.getKey();
                                break;
                            }
                            case PINK: {
                                head = DalekVariant.DALEK_PINK.getKey();
                                break;
                            }
                            case LIME: {
                                head = DalekVariant.DALEK_LIME.getKey();
                                break;
                            }
                            case YELLOW: {
                                head = DalekVariant.DALEK_YELLOW.getKey();
                                break;
                            }
                            case LIGHT_BLUE: {
                                head = DalekVariant.DALEK_LIGHT_BLUE.getKey();
                                break;
                            }
                            case MAGENTA: {
                                head = DalekVariant.DALEK_MAGENTA.getKey();
                                break;
                            }
                            case ORANGE: {
                                head = DalekVariant.DALEK_ORANGE.getKey();
                            }
                        }
                        ItemStack helmet = ItemStack.of((Material)Material.SLIME_BALL, (int)1);
                        ItemMeta headMeta = helmet.getItemMeta();
                        headMeta.displayName((Component)Component.text((String)"Dalek Head"));
                        headMeta.setItemModel(head);
                        helmet.setItemMeta(headMeta);
                        EntityEquipment ee = a.getEquipment();
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> ee.setHelmet(helmet), 2L);
                    }
                    catch (IllegalArgumentException colour) {}
                    break;
                }
                case ANGEL_OF_LIBERTY: 
                case THE_BEAST: {
                    new Equipper(monster, a, false).setHelmetAndInvisibility();
                    a.getAttribute(Attribute.SCALE).setBaseValue(2.5);
                    break;
                }
                case EMPTY_CHILD: {
                    new Equipper(monster, a, false).setHelmetAndInvisibility();
                    EmptyChildEquipment.setSpeed(a);
                    break;
                }
                case HEADLESS_MONK: {
                    new Equipper(monster, a, false).setHelmetAndInvisibility();
                    HeadlessMonkEquipment.setTasks(a);
                    int flameID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new HeadlessFlameRunnable(a), 1L, 20L);
                    a.getPersistentDataContainer().set(TARDISWeepingAngels.FLAME_TASK, PersistentDataType.INTEGER, (Object)flameID);
                    break;
                }
                case ICE_WARRIOR: {
                    new Equipper(monster, a, false).setHelmetAndInvisibility();
                    PigZombie pigman = (PigZombie)a;
                    pigman.setAngry(true);
                    pigman.setAnger(Integer.MAX_VALUE);
                    break;
                }
                case JUDOON: {
                    JudoonEquipment.set((OfflinePlayer)player, a, false);
                    break;
                }
                case K9: {
                    K9Equipment.set((OfflinePlayer)player, a, false);
                    break;
                }
                case OOD: {
                    OodEquipment.set((OfflinePlayer)player, a, false);
                    break;
                }
                case SILENT: {
                    new Equipper(monster, a, false).setHelmetAndInvisibility();
                    SilentEquipment.setGuardian(a);
                    break;
                }
                case STRAX: {
                    PigZombie strax = (PigZombie)a;
                    strax.setAngry(false);
                    new Equipper(monster, a, false).setHelmetAndInvisibility();
                    a.customName((Component)Component.text((String)"Strax"));
                    break;
                }
                case TOCLAFANE: {
                    ToclafaneEquipment.set((Entity)a, false);
                    break;
                }
                default: {
                    new Equipper(monster, a, false).setHelmetAndInvisibility();
                }
            }
            String sound = switch (monster) {
                case Monster.THE_BEAST -> "entity.ravager.roar";
                case Monster.CYBERSHADE -> "entity.hoglin.converted_to_zombified";
                case Monster.EMPTY_CHILD -> "empty";
                case Monster.HEADLESS_MONK -> "headless_monk";
                case Monster.ICE_WARRIOR -> "warrior";
                case Monster.MIRE -> "item.trident.thunder";
                case Monster.SEA_DEVIL -> "sea_devil";
                case Monster.SILENT -> "silence";
                case Monster.SMILER -> "entity.rabbit.attack";
                case Monster.VAMPIRE_OF_VENICE -> "entity.fish.swim";
                case Monster.WEEPING_ANGEL -> "blink";
                default -> monster.getPermission();
            };
            player.playSound(a.getLocation(), sound, 1.0f, 1.0f);
            this.plugin.getServer().getPluginManager().callEvent((Event)new TARDISWeepingAngelSpawnEvent((Entity)a, monster.getEntityType(), monster, eyeLocation));
        } else {
            this.plugin.getMessenger().send(sender, TardisModule.MONSTERS, "CMD_PLAYER");
        }
        return true;
    }
}

