/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.commands;

import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.keys.CybermanVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.DalekVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.DroidVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.MireVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.MonkVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.SlitheenVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.ToclafaneVariant;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.equip.ArmourStandEquipment;
import me.eccentric_nz.tardisweepingangels.monsters.headless_monks.HeadlessFlameRunnable;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.RayTraceResult;

public class EquipCommand {
    private final TARDIS plugin;

    public EquipCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean equip(CommandSender sender, String[] args) {
        Monster monster;
        if (args.length < 2) {
            return false;
        }
        String upper = args[1].toUpperCase(Locale.ROOT);
        try {
            monster = Monster.valueOf(upper);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getMessenger().send(sender, TardisModule.MONSTERS, "WA_INVALID");
            return true;
        }
        Player player = null;
        if (sender instanceof Player) {
            player = (Player)sender;
        }
        if (player == null) {
            this.plugin.getMessenger().send(sender, TardisModule.MONSTERS, "CMD_PLAYER");
            return true;
        }
        Location observerPos = player.getEyeLocation();
        RayTraceResult result = observerPos.getWorld().rayTraceEntities(observerPos, observerPos.getDirection(), 16.0, s -> s.getType() == EntityType.ARMOR_STAND);
        if (result == null) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "WA_STAND");
            return true;
        }
        ArmorStand as = (ArmorStand)result.getHitEntity();
        if (as != null) {
            new ArmourStandEquipment().setStandEquipment(as, monster, monster == Monster.EMPTY_CHILD);
            if (args.length > 2) {
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    EntityEquipment ee = as.getEquipment();
                    ItemStack head = ee.getHelmet();
                    ItemMeta meta = head.getItemMeta();
                    if (monster == Monster.HEADLESS_MONK) {
                        if (args[2].equals("flaming")) {
                            int flameID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new HeadlessFlameRunnable((LivingEntity)as), 1L, 20L);
                            as.getPersistentDataContainer().set(TARDISWeepingAngels.FLAME_TASK, PersistentDataType.INTEGER, (Object)flameID);
                            meta.setItemModel(MonkVariant.HEADLESS_MONK_STATIC.getKey());
                        } else {
                            meta.setItemModel(MonkVariant.HEADLESS_MONK_ALTERNATE.getKey());
                        }
                    }
                    if (monster == Monster.MIRE || monster == Monster.SLITHEEN) {
                        meta.setItemModel(monster == Monster.MIRE ? MireVariant.THE_MIRE_HELMETLESS.getKey() : SlitheenVariant.SLITHEEN_SUIT.getKey());
                    }
                    if (monster == Monster.CLOCKWORK_DROID) {
                        meta.setItemModel(DroidVariant.CLOCKWORK_DROID_FEMALE_STATIC.getKey());
                    }
                    if (monster == Monster.DALEK) {
                        try {
                            DyeColor colour = DyeColor.valueOf((String)args[2].toUpperCase(Locale.ROOT));
                            NamespacedKey c = DalekVariant.DALEK_BRASS.getKey();
                            switch (colour) {
                                case BLACK: {
                                    c = DalekVariant.DALEK_BLACK.getKey();
                                    break;
                                }
                                case WHITE: {
                                    c = DalekVariant.DALEK_WHITE.getKey();
                                    break;
                                }
                                case RED: {
                                    c = DalekVariant.DALEK_RED.getKey();
                                    break;
                                }
                                case BROWN: {
                                    c = DalekVariant.DALEK_BROWN.getKey();
                                    break;
                                }
                                case GREEN: {
                                    c = DalekVariant.DALEK_GREEN.getKey();
                                    break;
                                }
                                case BLUE: {
                                    c = DalekVariant.DALEK_BLUE.getKey();
                                    break;
                                }
                                case PURPLE: {
                                    c = DalekVariant.DALEK_PURPLE.getKey();
                                    break;
                                }
                                case CYAN: {
                                    c = DalekVariant.DALEK_CYAN.getKey();
                                    break;
                                }
                                case LIGHT_GRAY: {
                                    c = DalekVariant.DALEK_LIGHT_GRAY.getKey();
                                    break;
                                }
                                case GRAY: {
                                    c = DalekVariant.DALEK_GRAY.getKey();
                                    break;
                                }
                                case PINK: {
                                    c = DalekVariant.DALEK_PINK.getKey();
                                    break;
                                }
                                case LIME: {
                                    c = DalekVariant.DALEK_LIME.getKey();
                                    break;
                                }
                                case YELLOW: {
                                    c = DalekVariant.DALEK_YELLOW.getKey();
                                    break;
                                }
                                case LIGHT_BLUE: {
                                    c = DalekVariant.DALEK_LIGHT_BLUE.getKey();
                                    break;
                                }
                                case MAGENTA: {
                                    c = DalekVariant.DALEK_MAGENTA.getKey();
                                    break;
                                }
                                case ORANGE: {
                                    c = DalekVariant.DALEK_ORANGE.getKey();
                                }
                            }
                            meta.setItemModel(c);
                        }
                        catch (IllegalArgumentException colour) {
                            // empty catch block
                        }
                    }
                    if (monster == Monster.CYBERMAN) {
                        try {
                            CybermanVariant variant = CybermanVariant.valueOf(args[2].toUpperCase(Locale.ROOT) + "_STATIC");
                            meta.setItemModel(variant.getKey());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    if (monster == Monster.TOCLAFANE) {
                        meta.setItemModel(ToclafaneVariant.TOCLAFANE_ATTACK.getKey());
                    }
                    head.setItemMeta(meta);
                    ee.setHelmet(head);
                }, 2L);
            }
        }
        return true;
    }
}

