/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisregeneration;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.particles.ParticleRunnable;
import me.eccentric_nz.TARDIS.particles.Regeneration;
import org.bukkit.Location;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class RegenerationEmitter
extends ParticleRunnable
implements Runnable {
    private final TARDIS plugin;
    private final Player player;
    private final Location location;
    private final float yaw;

    public RegenerationEmitter(TARDIS plugin, Player player, Location location, float yaw) {
        super(plugin, player.getUniqueId());
        this.plugin = plugin;
        this.player = player;
        this.location = location;
        this.yaw = yaw;
    }

    @Override
    public void cancel() {
        this.plugin.getServer().getScheduler().cancelTask(this.taskID);
        this.taskID = 0;
        if (this.player.isOnline()) {
            this.player.setInvulnerable(false);
            Entity vehicle = this.player.getVehicle();
            if (vehicle != null) {
                vehicle.eject();
                vehicle.remove();
            }
            this.player.getAttribute(Attribute.SCALE).setBaseValue(1.0);
            this.player.removePotionEffect(PotionEffectType.INVISIBILITY);
            for (Player p : this.plugin.getServer().getOnlinePlayers()) {
                if (p.getWorld() != this.player.getWorld()) continue;
                p.showPlayer((Plugin)this.plugin, this.player);
            }
            if (this.plugin.getRegenerationConfig().getBoolean("effects.negative")) {
                this.player.addPotionEffect(new PotionEffect(PotionEffectType.SLOWNESS, 1800, 1));
                this.player.addPotionEffect(new PotionEffect(PotionEffectType.MINING_FATIGUE, 1800, 1));
                this.player.addPotionEffect(new PotionEffect(PotionEffectType.WEAKNESS, 1800, 1));
            }
            if (this.plugin.getRegenerationConfig().getBoolean("effects.positive")) {
                this.player.addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 1800, 1));
                this.player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_FALLING, 1800, 1));
            }
            if (this.plugin.getRegenerationConfig().getBoolean("restore.health")) {
                this.player.setHealth(this.player.getAttribute(Attribute.MAX_HEALTH).getDefaultValue());
            }
            if (this.plugin.getRegenerationConfig().getBoolean("restore.food") && this.player.getFoodLevel() < 20) {
                this.player.setFoodLevel(20);
            }
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                this.plugin.getSkinChanger().remove(this.player);
                this.player.removePotionEffect(PotionEffectType.SLOWNESS);
                this.player.removePotionEffect(PotionEffectType.WEAKNESS);
                this.player.removePotionEffect(PotionEffectType.REGENERATION);
            }, 1800L);
        }
    }

    @Override
    public void run() {
        if (this.t < 20.0) {
            Regeneration runnable = new Regeneration(this.plugin, this.player, this.location, this.yaw);
            int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, 0L, 1L);
            runnable.setTaskID(task);
            this.t += 1.0;
        } else {
            this.cancel();
        }
    }
}

