/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischemistry.block;

import java.util.HashSet;
import java.util.Set;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.customblocks.TARDISChemistryDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.customblocks.TARDISMushroomBlock;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.tardischemistry.compound.CompoundInventory;
import me.eccentric_nz.tardischemistry.constructor.ConstructorInventory;
import me.eccentric_nz.tardischemistry.element.ElementInventory;
import me.eccentric_nz.tardischemistry.lab.LabInventory;
import me.eccentric_nz.tardischemistry.product.ProductInventory;
import me.eccentric_nz.tardischemistry.reducer.ReducerInventory;
import net.kyori.adventure.text.Component;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;

public class ChemistryBlockListener
implements Listener {
    private final TARDIS plugin;
    private final Set<Material> blocks = new HashSet<Material>();

    public ChemistryBlockListener(TARDIS plugin) {
        this.plugin = plugin;
        this.blocks.add(Material.LIGHT_GRAY_CONCRETE);
        this.blocks.add(Material.ORANGE_CONCRETE);
        this.blocks.add(Material.MAGENTA_CONCRETE);
        this.blocks.add(Material.LIGHT_BLUE_CONCRETE);
        this.blocks.add(Material.YELLOW_CONCRETE);
        this.blocks.add(Material.LIME_CONCRETE);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onChemistryBlockInteract(PlayerInteractEvent event) {
        if (event.getAction().equals((Object)Action.RIGHT_CLICK_BLOCK) && event.getHand() != null && event.getHand().equals((Object)EquipmentSlot.HAND)) {
            Object menu;
            Block block = event.getClickedBlock();
            if (block == null) {
                return;
            }
            Material material = block.getType();
            if (!material.equals((Object)Material.BARRIER)) {
                return;
            }
            ItemDisplay display = TARDISDisplayItemUtils.get(block);
            if (display == null) {
                return;
            }
            ItemStack is = display.getItemStack();
            if (!this.blocks.contains(is.getType())) {
                return;
            }
            Player player = event.getPlayer();
            switch (is.getType()) {
                case LIGHT_GRAY_CONCRETE: {
                    if (TARDISPermission.hasPermission(player, "tardis.chemistry.creative")) {
                        menu = new ElementInventory(this.plugin);
                        break;
                    }
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CHEMISTRY_SUB_PERM", "Atomic elements");
                    return;
                }
                case ORANGE_CONCRETE: {
                    if (TARDISPermission.hasPermission(player, "tardis.compound.create")) {
                        menu = new CompoundInventory(this.plugin);
                        break;
                    }
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CHEMISTRY_SUB_PERM", "Chemical compounds");
                    return;
                }
                case MAGENTA_CONCRETE: {
                    if (TARDISPermission.hasPermission(player, "tardis.reducer.use")) {
                        menu = new ReducerInventory(this.plugin);
                        break;
                    }
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CHEMISTRY_SUB_PERM", "Material reducer");
                    return;
                }
                case LIGHT_BLUE_CONCRETE: {
                    if (TARDISPermission.hasPermission(player, "tardis.construct.build")) {
                        menu = new ConstructorInventory(this.plugin);
                        break;
                    }
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CHEMISTRY_SUB_PERM", "Element constructor");
                    return;
                }
                case YELLOW_CONCRETE: {
                    if (TARDISPermission.hasPermission(player, "tardis.lab.combine")) {
                        menu = new LabInventory(this.plugin);
                        break;
                    }
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CHEMISTRY_SUB_PERM", "Lab table");
                    return;
                }
                default: {
                    if (TARDISPermission.hasPermission(player, "tardis.products.craft")) {
                        menu = new ProductInventory(this.plugin);
                        break;
                    }
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CHEMISTRY_SUB_PERM", "Product crafting");
                    return;
                }
            }
            player.openInventory(menu.getInventory());
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onChemistryBlockBreak(BlockBreakEvent event) {
        TARDISDisplayItem tdi;
        Player player = event.getPlayer();
        if (player.getGameMode().equals((Object)GameMode.CREATIVE)) {
            return;
        }
        Block block = event.getBlock();
        Material mush = event.getBlock().getType();
        if ((mush.equals((Object)Material.RED_MUSHROOM_BLOCK) || mush.equals((Object)Material.MUSHROOM_STEM)) && (tdi = TARDISMushroomBlock.conversionMap.get(block.getBlockData().getAsString())) != null) {
            ItemStack is = ItemStack.of((Material)tdi.getMaterial(), (int)1);
            ItemMeta im = is.getItemMeta();
            im.displayName((Component)Component.text((String)tdi.getDisplayName()));
            im.setItemModel(tdi.getCustomModel());
            im.getPersistentDataContainer().set(this.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)tdi.getCustomModel().getKey());
            is.setItemMeta(im);
            block.setBlockData(TARDISConstants.AIR);
            block.getWorld().dropItemNaturally(event.getPlayer().getLocation(), is);
            if (tdi == TARDISChemistryDisplayItem.HEAT_BLOCK) {
                this.plugin.getTrackerKeeper().getHeatBlocks().remove(block.getLocation().toString());
            }
        }
    }
}

