/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.utility;

import java.io.File;
import java.io.IOException;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.SpawnCategory;
import org.mvplugins.multiverse.core.MultiverseCoreApi;
import org.mvplugins.multiverse.core.world.AllowedPortalType;
import org.mvplugins.multiverse.core.world.MultiverseWorld;

public class TARDISMultiverseImporter {
    private final TARDIS plugin;
    private final CommandSender sender;
    private final MultiverseCoreApi mvc = MultiverseCoreApi.get();

    public TARDISMultiverseImporter(TARDIS plugin, CommandSender sender) {
        this.plugin = plugin;
        this.sender = sender;
    }

    public void transfer() {
        int i = 0;
        for (MultiverseWorld mvw : this.mvc.getWorldManager().getWorlds()) {
            if (!this.plugin.getPlanetsConfig().contains("planets." + mvw.getName())) {
                this.plugin.getPlanetsConfig().set("planets." + mvw.getName() + ".enabled", (Object)mvw.isAutoLoad());
                this.plugin.getPlanetsConfig().set("planets." + mvw.getName() + ".resource-pack", (Object)"default");
                this.plugin.getPlanetsConfig().set("planets." + mvw.getName() + ".gamemode", (Object)mvw.getGameMode().toString());
                this.plugin.getPlanetsConfig().set("planets." + mvw.getName() + ".time_travel", (Object)false);
                this.plugin.getPlanetsConfig().set("planets." + mvw.getName() + ".environment", (Object)mvw.getEnvironment().toString());
                this.plugin.getPlanetsConfig().set("planets." + mvw.getName() + ".generator", (Object)mvw.getGenerator());
                this.plugin.getPlanetsConfig().set("planets." + mvw.getName() + ".spawn_chunk_radius", (Object)(mvw.isKeepSpawnInMemory() ? 2 : 0));
                if (!mvw.getEntitySpawnConfig().getSpawnCategoryConfig(SpawnCategory.ANIMAL).isSpawn() || !mvw.getEntitySpawnConfig().getSpawnCategoryConfig(SpawnCategory.MONSTER).isSpawn()) {
                    this.plugin.getPlanetsConfig().set("planets." + mvw.getName() + ".gamerules.spawn_mobs", (Object)false);
                }
                if (!mvw.isAllowWeather()) {
                    this.plugin.getPlanetsConfig().set("planets." + mvw.getName() + ".gamerules.advance_weather", (Object)false);
                }
                if (!mvw.getPvp()) {
                    this.plugin.getPlanetsConfig().set("planets." + mvw.getName() + ".gamerules.pvp", (Object)false);
                }
                this.plugin.getPlanetsConfig().set("planets." + mvw.getName() + ".allow_portals", (Object)(mvw.getPortalForm() != AllowedPortalType.NONE ? 1 : 0));
                this.plugin.getPlanetsConfig().set("planets." + mvw.getName() + ".alias", (Object)mvw.getAlias());
                this.plugin.getPlanetsConfig().set("planets." + mvw.getName() + ".helmic_regulator_order", (Object)-1);
                this.plugin.getPlanetsConfig().set("planets." + mvw.getName() + ".icon", (Object)(switch (mvw.getEnvironment()) {
                    case World.Environment.NETHER -> "NETHERRACK";
                    case World.Environment.THE_END -> "END_STONE";
                    default -> "STONE";
                }));
                this.plugin.getMessenger().send(this.sender, TardisModule.TARDIS, "MULTIVERSE_TRANSFER", mvw.getName());
                ++i;
                continue;
            }
            this.plugin.getMessenger().send(this.sender, TardisModule.TARDIS, "MULTIVERSE_EXISTS", mvw.getName());
        }
        if (i > 0) {
            try {
                String planetsPath = String.valueOf(this.plugin.getDataFolder()) + File.separator + "planets.yml";
                this.plugin.getPlanetsConfig().save(new File(planetsPath));
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Added " + i + " new items to planets.yml");
                this.plugin.getMessenger().send(this.sender, TardisModule.TARDIS, "MULTIVERSE_IMPORT", "" + i);
            }
            catch (IOException io) {
                this.plugin.debug("Could not save planets.yml, " + io.getMessage());
            }
        }
    }
}

