/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.schematic.setters;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.ShieldMeta;
import org.bukkit.plugin.Plugin;

public class ItemStackSetter {
    public static ItemStack build(JsonObject json) {
        if (!json.isEmpty()) {
            ItemStack is;
            block14: {
                Material material = Material.valueOf((String)json.get("item").getAsString());
                is = ItemStack.of((Material)material);
                ItemMeta im = is.getItemMeta();
                if (json.has("cmd")) {
                    String cmd = json.get("cmd").getAsString();
                    if (!cmd.equals("st_johns")) {
                        NamespacedKey key = new NamespacedKey((Plugin)TARDIS.plugin, cmd);
                        im.setItemModel(key);
                    } else {
                        im.displayName((Component)Component.text((String)"St John's Logo"));
                    }
                }
                if (json.has("name")) {
                    im.displayName(ComponentUtils.fromJson(json.get("name")));
                }
                if (json.has("lore")) {
                    ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
                    for (JsonElement element : json.get("lore").getAsJsonArray()) {
                        lore.add(Component.text((String)element.getAsString()));
                    }
                    im.lore(lore);
                }
                if (json.has("banner")) {
                    try {
                        JsonObject banner = json.get("banner").getAsJsonObject();
                        BannerMeta bm = (BannerMeta)im;
                        ShieldMeta sm = null;
                        if (material == Material.SHIELD) {
                            DyeColor baseColour = DyeColor.valueOf((String)banner.get("base_colour").getAsString());
                            sm = (ShieldMeta)bm;
                            sm.setBaseColor(baseColour);
                        }
                        JsonArray patterns = banner.get("patterns").getAsJsonArray();
                        ArrayList<Pattern> plist = new ArrayList<Pattern>();
                        for (int j = 0; j < patterns.size(); ++j) {
                            JsonObject jo = patterns.get(j).getAsJsonObject();
                            PatternType pt = (PatternType)RegistryAccess.registryAccess().getRegistry(RegistryKey.BANNER_PATTERN).get(new NamespacedKey("minecraft", jo.get("pattern").getAsString().toLowerCase(Locale.ROOT)));
                            if (pt == null) continue;
                            DyeColor dc = DyeColor.valueOf((String)jo.get("pattern_colour").getAsString());
                            Pattern p = new Pattern(dc, pt);
                            plist.add(p);
                        }
                        if (material == Material.SHIELD) {
                            sm.setPatterns(plist);
                            is.setItemMeta((ItemMeta)sm);
                            break block14;
                        }
                        bm.setPatterns(plist);
                        is.setItemMeta((ItemMeta)bm);
                    }
                    catch (IllegalArgumentException e) {
                        TARDIS.plugin.getMessenger().message((CommandSender)TARDIS.plugin.getConsole(), TardisModule.WARNING, "Could not create item stack for schematic item frame!");
                    }
                } else {
                    is.setItemMeta(im);
                }
            }
            return is;
        }
        return ItemStack.empty();
    }
}

