/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.schematic.archive;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ResultSetArchiveButtons {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String uuid;
    private final ItemStack[] buttons;
    private final String prefix;
    private final Material[] terracotta = new Material[]{Material.WHITE_TERRACOTTA, Material.ORANGE_TERRACOTTA, Material.MAGENTA_TERRACOTTA, Material.LIGHT_BLUE_TERRACOTTA, Material.YELLOW_TERRACOTTA, Material.LIME_TERRACOTTA, Material.PINK_TERRACOTTA, Material.GRAY_TERRACOTTA, Material.LIGHT_GRAY_TERRACOTTA, Material.CYAN_TERRACOTTA, Material.PURPLE_TERRACOTTA, Material.BLUE_TERRACOTTA, Material.BROWN_TERRACOTTA, Material.GREEN_TERRACOTTA, Material.RED_TERRACOTTA, Material.BLACK_TERRACOTTA};

    public ResultSetArchiveButtons(TARDIS plugin, String uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.prefix = this.plugin.getPrefix();
        this.buttons = new ItemStack[this.plugin.getConfig().getInt("archive.limit")];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block20: {
            Statement statement = null;
            ResultSet rs = null;
            String query = "SELECT * FROM " + this.prefix + "archive WHERE uuid = ?";
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                statement.setString(1, this.uuid);
                rs = statement.executeQuery();
                int i = 0;
                if (rs.isBeforeFirst()) {
                    while (rs.next()) {
                        ItemStack is = ItemStack.of((Material)this.terracotta[i], (int)1);
                        ItemMeta im = is.getItemMeta();
                        im.displayName((Component)Component.text((String)rs.getString("name")));
                        ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
                        if (!rs.getString("description").isEmpty()) {
                            Pattern p = Pattern.compile("\\G\\s*(.{1,25})(?=\\s|$)", 32);
                            Matcher m = p.matcher(rs.getString("description"));
                            while (m.find()) {
                                lore.add(Component.text((String)m.group(1)));
                            }
                        }
                        int cost = this.plugin.getArtronConfig().getInt("upgrades.archive." + rs.getString("console_size").toLowerCase(Locale.ROOT));
                        lore.add(Component.text((String)("Cost: " + cost)));
                        if (rs.getInt("use") == 1) {
                            lore.add(Component.text((String)this.plugin.getLanguage().getString("CURRENT_CONSOLE", "Your current console"), (TextColor)NamedTextColor.GREEN));
                        }
                        im.lore(lore);
                        is.setItemMeta(im);
                        this.buttons[i] = is;
                        if (++i <= 15) continue;
                        break block20;
                    }
                    break block20;
                }
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for archive buttons! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing archive buttons! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public ItemStack[] getButtons() {
        return this.buttons;
    }
}

