/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms.games.connect_four;

import org.bukkit.Material;

public class Grid {
    private final Material[][] grid = new Material[6][7];

    public Grid() {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.grid[i][j] = null;
            }
        }
    }

    public Material[][] getGrid() {
        return this.grid;
    }

    public void setToken(int row, int col, Material token) {
        this.grid[row][col] = token;
    }

    public void removeToken(int row, int col) {
        this.grid[row][col] = null;
    }

    public int getFirstAvailableRow(int col) {
        int maxRow = -1;
        for (int row = 5; row >= 0; --row) {
            if (this.grid[row][col] != null || row < maxRow) continue;
            maxRow = row;
        }
        return maxRow;
    }

    public boolean isColumnFull(int column) {
        return this.grid[0][column] != null;
    }

    public boolean areAllColumnsFull() {
        for (int i = 0; i < 7; ++i) {
            if (this.isColumnFull(i)) continue;
            return false;
        }
        return true;
    }

    public boolean isValidMove(int column) {
        return column >= 0 && column < 7 && !this.isColumnFull(column);
    }

    public boolean checkHorizontally() {
        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (!this.horizontalCondition(i, j)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean horizontalCondition(int i, int j) {
        return this.grid[i][j] != null && this.grid[i][j].equals((Object)this.grid[i][j + 1]) && this.grid[i][j].equals((Object)this.grid[i][j + 2]) && this.grid[i][j].equals((Object)this.grid[i][j + 3]);
    }

    public boolean checkVertically() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (!this.verticalCondition(i, j)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean verticalCondition(int i, int j) {
        return this.grid[i][j] != null && this.grid[i][j].equals((Object)this.grid[i + 1][j]) && this.grid[i][j].equals((Object)this.grid[i + 2][j]) && this.grid[i][j].equals((Object)this.grid[i + 3][j]);
    }

    public boolean checkDiagonally() {
        int j;
        int i;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 4; ++j) {
                if (!this.diagonalConditionLeftRight(i, j)) continue;
                return true;
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 3; j < 7; ++j) {
                if (!this.diagonalConditionRightLeft(i, j)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean diagonalConditionLeftRight(int i, int j) {
        return this.grid[i][j] != null && this.grid[i][j].equals((Object)this.grid[i + 1][j + 1]) && this.grid[i][j].equals((Object)this.grid[i + 2][j + 2]) && this.grid[i][j].equals((Object)this.grid[i + 3][j + 3]);
    }

    private boolean diagonalConditionRightLeft(int i, int j) {
        return this.grid[i][j] != null && this.grid[i][j].equals((Object)this.grid[i + 1][j - 1]) && this.grid[i][j].equals((Object)this.grid[i + 2][j - 2]) && this.grid[i][j].equals((Object)this.grid[i + 3][j - 3]);
    }
}

