/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetArtronStorageAndLevel;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCondenser;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetSmelter;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetVault;
import me.eccentric_nz.TARDIS.enumeration.SmelterChest;
import me.eccentric_nz.TARDIS.rooms.VaultDrop;
import me.eccentric_nz.TARDIS.rooms.library.LibrarySorter;
import me.eccentric_nz.TARDIS.rooms.smelter.SmelterFuel;
import me.eccentric_nz.TARDIS.rooms.smelter.SmelterOre;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Chest;
import org.bukkit.entity.CopperGolem;
import org.bukkit.entity.Entity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockRedstoneEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class CopperGolemListener
implements Listener {
    private final TARDIS plugin;
    private final List<String> zero;

    public CopperGolemListener(TARDIS plugin) {
        this.plugin = plugin;
        this.zero = this.plugin.getBlocksConfig().getStringList("no_artron_value");
    }

    @EventHandler
    public void onRedstone(BlockRedstoneEvent event) {
        Block block = event.getBlock();
        if (!block.getWorld().getName().contains("TARDIS")) {
            return;
        }
        BlockState blockState = block.getState();
        if (!(blockState instanceof Chest)) {
            return;
        }
        Chest chest = (Chest)blockState;
        Inventory inv = chest.getInventory();
        if (!inv.getViewers().isEmpty()) {
            return;
        }
        ItemStack[] contents = inv.getContents();
        Location loc = block.getLocation();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("type", 34);
        where.put("location", loc.toString());
        ResultSetControls rsc = new ResultSetControls(this.plugin, where, false);
        if (rsc.resultSet()) {
            if (this.plugin.getConfig().getBoolean("preferences.no_creative_condense")) {
                switch (this.plugin.getWorldManager()) {
                    case MULTIVERSE: {
                        if (this.plugin.getMVHelper().isWorldSurvival(block.getWorld())) break;
                        return;
                    }
                    case NONE: {
                        if (!this.plugin.getPlanetsConfig().getString("planets." + block.getWorld().getName() + ".gamemode", "SURVIVAL").equalsIgnoreCase("CREATIVE")) break;
                        return;
                    }
                }
            }
            if (this.golemIsNear(block)) {
                ArrayList<ItemStack> returnedItems = new ArrayList<ItemStack>();
                HashMap<String, Integer> item_counts = new HashMap<String, Integer>();
                int amount = 0;
                for (ItemStack is : contents) {
                    if (is == null) continue;
                    String item = is.getType().toString();
                    if (this.plugin.getCondensables().containsKey(item) && !this.zero.contains(item)) {
                        int stack_size = is.getAmount();
                        amount += stack_size * this.plugin.getCondensables().get(item);
                        String block_data = is.getType().toString();
                        if (this.plugin.getConfig().getBoolean("growth.rooms_require_blocks") || this.plugin.getConfig().getBoolean("allow.repair")) {
                            if (item_counts.containsKey(block_data)) {
                                Integer add_this = (Integer)item_counts.get(block_data) + stack_size;
                                item_counts.put(block_data, add_this);
                            } else {
                                item_counts.put(block_data, stack_size);
                            }
                        }
                        this.plugin.debug("Golem condense " + String.valueOf(is.getType()));
                        continue;
                    }
                    returnedItems.add(is);
                }
                int id = rsc.getTardis_id();
                amount = Math.round((float)amount / 2.0f);
                ResultSetArtronStorageAndLevel rsas = new ResultSetArtronStorageAndLevel(this.plugin);
                int full = this.plugin.getArtronConfig().getInt("full_charge", 5000);
                if (rsas.fromID(id)) {
                    int damage = full / 2 * rsas.getDamageCount();
                    int max = full * rsas.getCapacitorCount() - damage;
                    int current = rsas.getCurrentLevel();
                    if (current + amount > max) {
                        return;
                    }
                    chest.getInventory().clear();
                    if (this.plugin.getConfig().getBoolean("growth.rooms_require_blocks") || this.plugin.getConfig().getBoolean("allow.repair")) {
                        item_counts.forEach((key, value) -> {
                            HashMap<String, Object> wherec = new HashMap<String, Object>();
                            wherec.put("tardis_id", id);
                            wherec.put("block_data", key);
                            ResultSetCondenser rscon = new ResultSetCondenser(this.plugin, wherec);
                            HashMap<String, Object> setc = new HashMap<String, Object>();
                            if (rscon.resultSet()) {
                                int new_stack_size = value + rscon.getBlock_count();
                                this.plugin.getQueryFactory().updateCondensedBlockCount(new_stack_size, id, (String)key);
                            } else {
                                setc.put("tardis_id", id);
                                setc.put("block_data", key);
                                setc.put("block_count", value);
                                this.plugin.getQueryFactory().doInsert("condenser", setc);
                            }
                        });
                    }
                    HashMap<String, Object> wheret = new HashMap<String, Object>();
                    wheret.put("tardis_id", id);
                    this.plugin.getQueryFactory().alterEnergyLevel("tardis", amount, wheret, null);
                    for (ItemStack ret : returnedItems) {
                        chest.getInventory().addItem(new ItemStack[]{ret});
                    }
                }
            }
        } else {
            ResultSetVault rsv = new ResultSetVault(this.plugin);
            if (!rsv.fromLocation(loc.toString())) {
                return;
            }
            SmelterChest type = rsv.getChestType();
            List<Chest> fuelChests = null;
            List<Chest> oreChests = null;
            if (type == SmelterChest.FUEL || type == SmelterChest.SMELT) {
                ResultSetSmelter rss = new ResultSetSmelter(this.plugin, loc.toString());
                if (!rss.resultSet()) {
                    return;
                }
                fuelChests = rss.getFuelChests();
                oreChests = rss.getOreChests();
            }
            switch (type) {
                case DROP: {
                    new VaultDrop(this.plugin).processItems(inv, rsv);
                    break;
                }
                case FUEL: {
                    if (fuelChests == null) break;
                    new SmelterFuel().processItems(inv, fuelChests);
                    break;
                }
                case SMELT: {
                    if (oreChests == null) break;
                    new SmelterOre().processItems(inv, oreChests);
                    break;
                }
                case LIBRARY: {
                    new LibrarySorter(this.plugin).distribute(inv, loc.add(-8.0, -4.0, -8.0));
                    break;
                }
            }
        }
    }

    private boolean golemIsNear(Block block) {
        boolean golemIsNear = false;
        for (Entity entity : block.getWorld().getNearbyEntities(block.getBoundingBox().expand(1.0))) {
            if (!(entity instanceof CopperGolem)) continue;
            golemIsNear = true;
            break;
        }
        return golemIsNear;
    }
}

