/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.handles;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.event.TARDISArtronEvent;
import me.eccentric_nz.TARDIS.api.event.TARDISDematerialisationEvent;
import me.eccentric_nz.TARDIS.api.event.TARDISEnterEvent;
import me.eccentric_nz.TARDIS.api.event.TARDISExitEvent;
import me.eccentric_nz.TARDIS.api.event.TARDISHADSEvent;
import me.eccentric_nz.TARDIS.api.event.TARDISMaterialisationEvent;
import me.eccentric_nz.TARDIS.api.event.TARDISSiegeEvent;
import me.eccentric_nz.TARDIS.api.event.TARDISSiegeOffEvent;
import me.eccentric_nz.TARDIS.database.data.Program;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetProgramFromEvent;
import me.eccentric_nz.TARDIS.handles.HandlesBlock;
import me.eccentric_nz.TARDIS.handles.HandlesProcessor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class HandlesEventListener
implements Listener {
    private final Callback<Program> programCallback = program -> {
        Player player = Bukkit.getPlayer((UUID)UUID.fromString(program.getUuid()));
        if (player != null && player.isOnline()) {
            ItemStack[] stack = program.getInventory();
            int i = 0;
            for (ItemStack is : stack) {
                if (is != null) {
                    HandlesBlock thb = HandlesBlock.BY_NAME.get(is.getItemMeta().displayName());
                    HandlesProcessor processor = new HandlesProcessor(TARDIS.plugin, (Program)program, player, program.getProgram_id());
                    switch (thb) {
                        case ARTRON: {
                            processor.processArtronCommand(i + 1);
                            return;
                        }
                        case DO: {
                            processor.processCommand(i + 1);
                            return;
                        }
                    }
                }
                ++i;
            }
        }
    };

    public void onHandlesArtron(TARDISArtronEvent event) {
        this.getProgram(event.getPlayer().getUniqueId().toString(), "ARTRON");
    }

    public void onHandlesSiegeOff(TARDISSiegeOffEvent event) {
        this.getProgram(event.getPlayer().getUniqueId().toString(), "SIEGE_OFF");
    }

    public void onHandlesSiegeOn(TARDISSiegeEvent event) {
        this.getProgram(event.getPlayer().getUniqueId().toString(), "SIEGE_ON");
    }

    public void onHandlesMaterialise(TARDISMaterialisationEvent event) {
        this.getProgram(event.getPlayer().getUniqueId().toString(), "MATERIALISE");
    }

    public void onHandlesDematerialise(TARDISDematerialisationEvent event) {
        this.getProgram(event.getPlayer().getUniqueId().toString(), "DEMATERIALISE");
    }

    public void onHandlesEnter(TARDISEnterEvent event) {
        this.getProgram(event.getPlayer().getUniqueId().toString(), "ENTER");
    }

    public void onHandlesExit(TARDISExitEvent event) {
        this.getProgram(event.getPlayer().getUniqueId().toString(), "EXIT");
    }

    public void onHandlesHADS(TARDISHADSEvent event) {
        this.getProgram(event.getPlayer().getUniqueId().toString(), "HADS");
    }

    public void onHandlesLogout(PlayerQuitEvent event) {
        this.getProgram(event.getPlayer().getUniqueId().toString(), "LOG_OUT");
    }

    public void onHandlesTimeLordDeath(PlayerDeathEvent event) {
        this.getProgram(event.getEntity().getUniqueId().toString(), "DEATH");
    }

    private void getProgram(final String uuid, final String event) {
        if (TARDIS.plugin.getHandlesConfig().getBoolean("enabled")) {
            new BukkitRunnable(){

                public void run() {
                    ResultSetProgramFromEvent rs = new ResultSetProgramFromEvent(TARDIS.plugin, uuid, event);
                    if (rs.resultSet()) {
                        HandlesEventListener.this.programCallback.execute(rs.getProgram());
                    }
                }
            }.runTaskAsynchronously((Plugin)TARDIS.plugin);
        }
    }

    static interface Callback<T> {
        public void execute(T var1);
    }
}

