/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.floodgate;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.Transmat;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTransmat;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTransmatList;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.response.SimpleFormResponse;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class FloodgateTransmatForm {
    private final TARDIS plugin;
    private final UUID uuid;
    private final int id;

    public FloodgateTransmatForm(TARDIS plugin, UUID uuid, int id) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.id = id;
    }

    public void send() {
        ResultSetTransmatList rslist = new ResultSetTransmatList(this.plugin, this.id);
        if (rslist.resultSet()) {
            SimpleForm.Builder builder = SimpleForm.builder();
            builder.title("TARDIS transmats");
            for (Transmat t : rslist.getData()) {
                builder.button(t.name());
            }
            builder.validResultHandler(this::handleResponse);
            SimpleForm form = (SimpleForm)builder.build();
            FloodgatePlayer player = FloodgateApi.getInstance().getPlayer(this.uuid);
            player.sendForm((Form)form);
        } else {
            this.plugin.getMessenger().send((CommandSender)this.plugin.getServer().getPlayer(this.uuid), TardisModule.TARDIS, "TRANSMAT_NO_LIST");
        }
    }

    private void handleResponse(SimpleFormResponse response) {
        String label = response.clickedButton().text();
        Player player = this.plugin.getServer().getPlayer(this.uuid);
        ResultSetTransmat rst = new ResultSetTransmat(this.plugin, this.id, label);
        if (rst.resultSet()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRANSMAT");
            Location tp_loc = rst.getLocation();
            tp_loc.setYaw(rst.getYaw());
            tp_loc.setPitch(player.getLocation().getPitch());
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                player.playSound(tp_loc, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
                player.teleport(tp_loc);
            }, 10L);
        }
    }
}

