/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.floodgate;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.floodgate.FloodgateIndexEntryForm;
import me.eccentric_nz.TARDIS.info.TARDISInfoMenu;
import me.eccentric_nz.TARDIS.info.TISCategory;
import me.eccentric_nz.TARDIS.info.TISInfo;
import me.eccentric_nz.TARDIS.info.TISRoomInfo;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.response.SimpleFormResponse;
import org.geysermc.cumulus.util.FormImage;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class FloodgateIndexSectionForm {
    private final TARDIS plugin;
    private final UUID uuid;
    private final TISCategory category;

    public FloodgateIndexSectionForm(TARDIS plugin, UUID uuid, TISCategory category) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.category = category;
    }

    public void send() {
        SimpleForm.Builder builder = SimpleForm.builder();
        builder.title("TARDIS Info: " + this.category.getName());
        for (TARDISInfoMenu tim : TARDISInfoMenu.values()) {
            if (this.category == TISCategory.ITEMS && tim.isItem()) {
                builder.button(TARDISStringUtils.capitalise(tim.toString()), FormImage.Type.PATH, "textures/items/written_book.png");
                continue;
            }
            if (this.category == TISCategory.CONSOLE_BLOCKS && tim.isConsoleBlock()) {
                builder.button(TARDISStringUtils.capitalise(tim.toString()), FormImage.Type.PATH, "textures/items/written_book.png");
                continue;
            }
            if (this.category == TISCategory.ACCESSORIES && tim.isAccessory()) {
                builder.button(TARDISStringUtils.capitalise(tim.toString()), FormImage.Type.PATH, "textures/items/written_book.png");
                continue;
            }
            if (this.category == TISCategory.COMPONENTS && tim.isComponent()) {
                builder.button(TARDISStringUtils.capitalise(tim.toString()), FormImage.Type.PATH, "textures/items/written_book.png");
                continue;
            }
            if (this.category == TISCategory.SONIC_COMPONENTS && tim.isSonicComponent()) {
                builder.button(TARDISStringUtils.capitalise(tim.toString()), FormImage.Type.PATH, "textures/items/written_book.png");
                continue;
            }
            if (this.category == TISCategory.SONIC_UPGRADES && tim.isSonicUpgrade()) {
                builder.button(TARDISStringUtils.capitalise(tim.toString()), FormImage.Type.PATH, "textures/items/written_book.png");
                continue;
            }
            if (this.category == TISCategory.CONSOLES && tim.isConsole()) {
                builder.button(TARDISStringUtils.capitalise(tim.toString()), FormImage.Type.PATH, "textures/items/written_book.png");
                continue;
            }
            if (this.category == TISCategory.DISKS && tim.isDisk()) {
                builder.button(TARDISStringUtils.capitalise(tim.toString()), FormImage.Type.PATH, "textures/items/written_book.png");
                continue;
            }
            if (this.category == TISCategory.ROOMS && tim.isRoom()) {
                builder.button(TARDISStringUtils.capitalise(tim.toString()), FormImage.Type.PATH, "textures/items/written_book.png");
                continue;
            }
            if (this.category == TISCategory.PLANETS && tim.isPlanet()) {
                builder.button(TARDISStringUtils.capitalise(tim.toString()), FormImage.Type.PATH, "textures/items/written_book.png");
                continue;
            }
            if (this.category == TISCategory.TIME_TRAVEL && tim.isTimeTravel()) {
                builder.button(TARDISStringUtils.capitalise(tim.toString()), FormImage.Type.PATH, "textures/items/written_book.png");
                continue;
            }
            if (this.category == TISCategory.FOOD && tim.isFood()) {
                builder.button(TARDISStringUtils.capitalise(tim.toString()), FormImage.Type.PATH, "textures/items/written_book.png");
                continue;
            }
            if (this.category == TISCategory.UPDATEABLE_BLOCKS && tim.isUpdateable()) {
                builder.button(TARDISStringUtils.capitalise(tim.toString()), FormImage.Type.PATH, "textures/items/written_book.png");
                continue;
            }
            if (this.category != TISCategory.MONSTERS || !tim.isMonster()) continue;
            builder.button(TARDISStringUtils.capitalise(tim.toString()), FormImage.Type.PATH, "textures/items/written_book.png");
        }
        builder.validResultHandler(this::handleResponse);
        SimpleForm form = (SimpleForm)builder.build();
        FloodgatePlayer player = FloodgateApi.getInstance().getPlayer(this.uuid);
        player.sendForm((Form)form);
    }

    private void handleResponse(SimpleFormResponse response) {
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        String name = TARDISStringUtils.toEnumUppercase(response.clickedButton().text());
        try {
            TARDISInfoMenu tim = TARDISInfoMenu.valueOf(name);
            if (this.category == TISCategory.ROOMS) {
                new TISRoomInfo(this.plugin).show(player, tim);
            } else if (this.category.isFirstLevel() && !this.hasRecipe(tim) || this.category == TISCategory.MONSTERS && tim != TARDISInfoMenu.K9) {
                new TISInfo(this.plugin).show(player, tim);
            } else {
                new FloodgateIndexEntryForm(this.plugin, this.uuid, tim).send();
                this.plugin.getTrackerKeeper().getFlight().put(this.uuid, tim.toString());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private boolean hasRecipe(TARDISInfoMenu tim) {
        switch (tim) {
            case EXTERIOR_LAMP_LEVEL_SWITCH: 
            case INTERIOR_LIGHT_LEVEL_SWITCH: 
            case TARDIS_MONITOR: 
            case MONITOR_FRAME: {
                return true;
            }
        }
        return false;
    }
}

