/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.flight;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.sensor.FlightSensor;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

class TravelBar {
    private final TARDIS plugin;
    private final int id;
    private int taskID;

    public TravelBar(TARDIS plugin, int id) {
        this.plugin = plugin;
        this.id = id;
    }

    void showTravelRemaining(Player player, long duration, boolean takeoff) {
        String title = takeoff ? this.plugin.getLanguage().getString("TRAVEL_BAR_TAKEOFF") : this.plugin.getLanguage().getString("TRAVEL_BAR_LAND");
        BossBar bb = Bukkit.createBossBar((String)title, (BarColor)BarColor.WHITE, (BarStyle)BarStyle.SOLID, (BarFlag[])TARDISConstants.EMPTY_ARRAY);
        bb.setProgress(0.0);
        bb.addPlayer(player);
        bb.setVisible(true);
        double millis = (double)duration * 50.0;
        long start = System.currentTimeMillis();
        double end = (double)start + millis;
        if (takeoff) {
            new FlightSensor(this.plugin, this.id).toggle();
        }
        this.taskID = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, () -> {
            long now = System.currentTimeMillis();
            if ((double)now < end) {
                double progress = 1.0 - (end - (double)now) / millis;
                bb.setProgress(progress);
            } else {
                bb.setProgress(1.0);
                bb.setVisible(false);
                bb.removeAll();
                Bukkit.getScheduler().cancelTask(this.taskID);
                this.taskID = 0;
                if (!takeoff) {
                    new FlightSensor(this.plugin, this.id).toggle();
                }
            }
        }, 1L, 1L);
    }
}

