/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.enumeration;

import java.util.HashMap;

public enum Time {
    DAY(0L),
    MORNING(0L),
    NOON(6000L),
    NIGHT(12000L),
    MIDNIGHT(18000L),
    AM_6(0L),
    AM_7(1000L),
    AM_8(2000L),
    AM_9(3000L),
    AM_10(4000L),
    AM_11(5000L),
    PM_12(6000L),
    PM_1(7000L),
    PM_2(8000L),
    PM_3(9000L),
    PM_4(10000L),
    PM_5(11000L),
    PM_6(12000L),
    PM_7(13000L),
    PM_8(14000L),
    PM_9(15000L),
    PM_10(16000L),
    PM_11(17000L),
    AM_12(18000L),
    AM_1(19000L),
    AM_2(20000L),
    AM_3(21000L),
    AM_4(22000L),
    AM_5(23000L);

    private static final HashMap<String, Time> BY_NAME;
    private final long ticks;
    private final String name;

    private Time(long ticks) {
        this.ticks = ticks;
        this.name = this.getName();
    }

    public static HashMap<String, Time> getByName() {
        return BY_NAME;
    }

    public long getTicks() {
        return this.ticks;
    }

    private String getName() {
        String[] split = this.toString().split("_");
        return split.length == 2 ? split[1] + split[0] : split[0];
    }

    static {
        BY_NAME = new HashMap();
        for (Time time : Time.values()) {
            BY_NAME.put(time.name, time);
        }
    }
}

