/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.converters;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;

public class GrassConverter {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;

    public GrassConverter(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkBlockData() {
        Statement statement = null;
        Statement ps = null;
        ResultSet rs = null;
        String query = "SELECT b_id, data FROM " + this.prefix + "blocks where data = 'minecraft:grass'";
        String update = "UPDATE " + this.prefix + "blocks SET data = 'minecraft:short_grass' WHERE b_id = ?";
        int i = 0;
        try {
            this.service.testConnection(this.connection);
            this.connection.setAutoCommit(false);
            statement = this.connection.prepareStatement(query);
            ps = this.connection.prepareStatement(update);
            rs = statement.executeQuery();
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    int b_id = rs.getInt("b_id");
                    ps.setInt(1, b_id);
                    ps.addBatch();
                    ++i;
                }
            }
            if (i > 0) {
                ps.executeBatch();
                this.connection.commit();
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Converted " + i + " grass to short_grass");
            }
            this.plugin.getConfig().set("conversions.short_grass", (Object)true);
            this.plugin.saveConfig();
        }
        catch (SQLException e) {
            this.plugin.debug("Conversion error for blocks short_grass! " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (ps != null) {
                    ps.close();
                }
                if (statement != null) {
                    statement.close();
                }
                this.connection.setAutoCommit(true);
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing blocks table (short_grass)! " + e.getMessage());
            }
        }
    }
}

