/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis.update;

import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.chatGUI.UpdateChatGUI;
import me.eccentric_nz.TARDIS.commands.sudo.TARDISSudoTracker;
import me.eccentric_nz.TARDIS.commands.tardis.update.UpdateBlocksCommand;
import me.eccentric_nz.TARDIS.commands.tardis.update.UpdateLungeCommand;
import me.eccentric_nz.TARDIS.customblocks.TARDISBlockDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.Updateable;
import me.eccentric_nz.TARDIS.messaging.TARDISUpdateLister;
import me.eccentric_nz.TARDIS.monitor.MonitorUtils;
import me.eccentric_nz.TARDIS.rotors.TimeRotor;
import me.eccentric_nz.TARDIS.sonic.SonicDock;
import me.eccentric_nz.TARDIS.update.TARDISUpdateBlocks;
import me.eccentric_nz.TARDIS.update.TARDISUpdateableChecker;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Door;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class UpdateCommand {
    private final TARDIS plugin;

    public UpdateCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean startUpdate(Player player, String[] args) {
        if (TARDISPermission.hasPermission(player, "tardis.update")) {
            Block block;
            Updateable updateable;
            if (args.length == 1) {
                return new UpdateChatGUI(this.plugin).showInterface(player, args);
            }
            if (args.length < 2) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
                return false;
            }
            if (args[1].equalsIgnoreCase("list")) {
                for (Updateable u : Updateable.values()) {
                    System.out.println(u.getName() + " valid blocks:");
                    for (Material m : u.getMaterialChoices()) {
                        String s = m.toString();
                        if (s.equals("SPAWNER")) {
                            System.out.println("   ANY BLOCK");
                            continue;
                        }
                        System.out.println("   " + s);
                    }
                }
                return true;
            }
            if (args[1].equalsIgnoreCase("blocks")) {
                return new UpdateBlocksCommand(this.plugin).convert(player);
            }
            if (args[1].equalsIgnoreCase("lunge")) {
                return new UpdateLungeCommand(this.plugin).addChiseledShelves(player);
            }
            if (args[1].equalsIgnoreCase("remove_displays")) {
                return new UpdateBlocksCommand(this.plugin).remove_displays(player);
            }
            UUID playerUUID = player.getUniqueId();
            if (args[1].equalsIgnoreCase("handles")) {
                if (args.length > 2) {
                    if (args[2].equalsIgnoreCase("lock")) {
                        this.plugin.getTrackerKeeper().getHandlesRotation().remove(playerUUID);
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.HANDLES, "HANDLES_LOCKED");
                    } else {
                        this.plugin.getTrackerKeeper().getHandlesRotation().add(playerUUID);
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.HANDLES, "HANDLES_ROTATE");
                    }
                    return true;
                }
                return false;
            }
            HashMap<String, Object> where = new HashMap<String, Object>();
            UUID uuid = TARDISSudoTracker.SUDOERS.getOrDefault(playerUUID, playerUUID);
            where.put("uuid", uuid);
            ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
            if (!rs.resultSet()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_A_TIMELORD");
                return false;
            }
            Tardis tardis = rs.getTardis();
            String tardis_block = TARDISStringUtils.toScoredUppercase(args[1]);
            try {
                updateable = Updateable.valueOf(tardis_block);
            }
            catch (IllegalArgumentException e) {
                new TARDISUpdateLister(this.plugin, player).list();
                return true;
            }
            if (args.length == 3 && args[2].equalsIgnoreCase("blocks")) {
                TARDISUpdateBlocks.showOptions(player, updateable);
                return true;
            }
            if (updateable.equals((Object)Updateable.HINGE)) {
                Block block2 = player.getTargetBlock(this.plugin.getGeneralKeeper().getTransparent(), 10);
                if (block2.getType().equals((Object)Material.IRON_DOOR)) {
                    Door door = (Door)block2.getBlockData();
                    if (args.length == 3) {
                        Door.Hinge setHinge = Door.Hinge.valueOf((String)args[2].toUpperCase(Locale.ROOT));
                        door.setHinge(setHinge);
                    } else {
                        Door.Hinge hinge = door.getHinge();
                        if (hinge.equals((Object)Door.Hinge.LEFT)) {
                            door.setHinge(Door.Hinge.RIGHT);
                        } else {
                            door.setHinge(Door.Hinge.LEFT);
                        }
                    }
                    block2.setBlockData((BlockData)door);
                }
                return true;
            }
            if (updateable.equals((Object)Updateable.STORAGE) && ((block = player.getTargetBlock(this.plugin.getGeneralKeeper().getTransparent(), 10)).getType().equals((Object)Material.NOTE_BLOCK) || block.getType().equals((Object)Material.MUSHROOM_STEM))) {
                block.setBlockData(TARDISConstants.BARRIER, true);
                TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.DISK_STORAGE, block, tardis.getTardisId());
            }
            if (new TARDISUpdateableChecker(this.plugin, updateable, player, tardis, tardis_block).canUpdate()) {
                if ((updateable.equals((Object)Updateable.ROTOR) || updateable.equals((Object)Updateable.MONITOR) || updateable.equals((Object)Updateable.MONITOR_FRAME) || updateable.equals((Object)Updateable.SONIC_DOCK)) && args.length == 3 && args[2].equalsIgnoreCase("unlock")) {
                    ItemFrame itemFrame = null;
                    switch (updateable) {
                        case ROTOR: {
                            itemFrame = TimeRotor.getItemFrame(tardis.getRotor());
                            break;
                        }
                        case MONITOR: {
                            itemFrame = MonitorUtils.getItemFrameFromLocation(tardis.getTardisId(), true);
                            break;
                        }
                        case MONITOR_FRAME: {
                            itemFrame = MonitorUtils.getItemFrameFromLocation(tardis.getTardisId(), false);
                            ItemStack glass = itemFrame.getItem();
                            ItemMeta im = glass.getItemMeta();
                            im.displayName((Component)ComponentUtils.toWhite("Monitor Frame"));
                            glass.setItemMeta(im);
                            break;
                        }
                        case SONIC_DOCK: {
                            itemFrame = SonicDock.getItemFrame(tardis.getTardisId());
                        }
                    }
                    if (itemFrame != null) {
                        TimeRotor.unlockItemFrame(itemFrame);
                        this.plugin.getGeneralKeeper().getTimeRotors().remove(itemFrame.getUniqueId());
                        Block block3 = itemFrame.getLocation().getBlock();
                        String location = block3.getLocation().toString();
                        this.plugin.getGeneralKeeper().getProtectBlockMap().remove(location);
                        String under = block3.getRelative(BlockFace.DOWN).getLocation().toString();
                        this.plugin.getGeneralKeeper().getProtectBlockMap().remove(under);
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ROTOR_UNFIXED");
                    }
                    return true;
                }
                this.plugin.getTrackerKeeper().getUpdatePlayers().put(playerUUID, tardis_block);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "UPDATE_CLICK", tardis_block);
                if (updateable.equals((Object)Updateable.DIRECTION)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "HOOK_REMIND");
                }
            }
            return true;
        }
        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
        return false;
    }
}

