/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.DiskWriterCommand;
import me.eccentric_nz.TARDIS.arch.TARDISArchCommand;
import me.eccentric_nz.TARDIS.chatGUI.UpdateChatGUI;
import me.eccentric_nz.TARDIS.commands.TARDISCommandHelper;
import me.eccentric_nz.TARDIS.commands.tardis.ARSRemoveCommand;
import me.eccentric_nz.TARDIS.commands.tardis.AbandonCommand;
import me.eccentric_nz.TARDIS.commands.tardis.AbortCommand;
import me.eccentric_nz.TARDIS.commands.tardis.AddCompanionCommand;
import me.eccentric_nz.TARDIS.commands.tardis.ArchiveCommand;
import me.eccentric_nz.TARDIS.commands.tardis.BellCommand;
import me.eccentric_nz.TARDIS.commands.tardis.CheckLocationCommand;
import me.eccentric_nz.TARDIS.commands.tardis.ColouriseCommand;
import me.eccentric_nz.TARDIS.commands.tardis.ComehereCommand;
import me.eccentric_nz.TARDIS.commands.tardis.ConstructCommand;
import me.eccentric_nz.TARDIS.commands.tardis.DecommissionCommand;
import me.eccentric_nz.TARDIS.commands.tardis.DirectionCommand;
import me.eccentric_nz.TARDIS.commands.tardis.DoorCommand;
import me.eccentric_nz.TARDIS.commands.tardis.EjectCommand;
import me.eccentric_nz.TARDIS.commands.tardis.EmergencyProgrammeOneCommand;
import me.eccentric_nz.TARDIS.commands.tardis.ExciteCommand;
import me.eccentric_nz.TARDIS.commands.tardis.ExterminateCommand;
import me.eccentric_nz.TARDIS.commands.tardis.FindCommand;
import me.eccentric_nz.TARDIS.commands.tardis.HandbrakeCommand;
import me.eccentric_nz.TARDIS.commands.tardis.HelpCommand;
import me.eccentric_nz.TARDIS.commands.tardis.HideCommand;
import me.eccentric_nz.TARDIS.commands.tardis.InsideCommand;
import me.eccentric_nz.TARDIS.commands.tardis.ItemCommand;
import me.eccentric_nz.TARDIS.commands.tardis.JettisonCommand;
import me.eccentric_nz.TARDIS.commands.tardis.LampsCommand;
import me.eccentric_nz.TARDIS.commands.tardis.ListCommand;
import me.eccentric_nz.TARDIS.commands.tardis.MakeHerBlueCommand;
import me.eccentric_nz.TARDIS.commands.tardis.MonstersCommand;
import me.eccentric_nz.TARDIS.commands.tardis.NameKeyCommand;
import me.eccentric_nz.TARDIS.commands.tardis.OccupyCommand;
import me.eccentric_nz.TARDIS.commands.tardis.RebuildCommand;
import me.eccentric_nz.TARDIS.commands.tardis.RemoveCompanionCommand;
import me.eccentric_nz.TARDIS.commands.tardis.RemoveSavedLocationCommand;
import me.eccentric_nz.TARDIS.commands.tardis.RenameSavedLocationCommand;
import me.eccentric_nz.TARDIS.commands.tardis.ReorderSavedLocationCommand;
import me.eccentric_nz.TARDIS.commands.tardis.RescueCommand;
import me.eccentric_nz.TARDIS.commands.tardis.RoomCommand;
import me.eccentric_nz.TARDIS.commands.tardis.SaveIconCommand;
import me.eccentric_nz.TARDIS.commands.tardis.SaveLocationCommand;
import me.eccentric_nz.TARDIS.commands.tardis.SecondaryCommand;
import me.eccentric_nz.TARDIS.commands.tardis.SetDestinationCommand;
import me.eccentric_nz.TARDIS.commands.tardis.SetHomeCommand;
import me.eccentric_nz.TARDIS.commands.tardis.SiegeCubeCommand;
import me.eccentric_nz.TARDIS.commands.tardis.StopSoundCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TagCommand;
import me.eccentric_nz.TARDIS.commands.tardis.ThemeMusicCommand;
import me.eccentric_nz.TARDIS.commands.tardis.TransmatCommand;
import me.eccentric_nz.TARDIS.commands.tardis.UpgradeCommand;
import me.eccentric_nz.TARDIS.commands.tardis.VersionCommand;
import me.eccentric_nz.TARDIS.commands.tardis.update.UpdateCommand;
import me.eccentric_nz.TARDIS.commands.utils.RescueAcceptor;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.TardisCommand;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.travel.ComehereAction;
import me.eccentric_nz.TARDIS.travel.ComehereRequest;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class TARDISCommands
implements CommandExecutor {
    private final TARDIS plugin;

    public TARDISCommands(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardis")) {
            TardisCommand tc;
            Player player = null;
            if (sender instanceof Player) {
                player = (Player)sender;
            }
            if (args.length == 0) {
                new TARDISCommandHelper(this.plugin).getCommand("", sender);
                return true;
            }
            String first = args[0].toLowerCase(Locale.ROOT);
            try {
                tc = TardisCommand.valueOf(first);
            }
            catch (IllegalArgumentException e) {
                if (first.equals("call")) {
                    UUID chatter = player.getUniqueId();
                    if (this.plugin.getTrackerKeeper().getComehereRequests().containsKey(chatter)) {
                        ComehereRequest request = this.plugin.getTrackerKeeper().getComehereRequests().get(chatter);
                        new ComehereAction(this.plugin).doTravel(request);
                        this.plugin.getTrackerKeeper().getComehereRequests().remove(chatter);
                    } else {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "REQUEST_TIMEOUT");
                    }
                } else if (first.equals("request")) {
                    new RescueAcceptor(this.plugin).doRequest(player, true);
                } else {
                    this.plugin.getMessenger().message(sender, TardisModule.TARDIS, "That command wasn't recognised type '/tardis help' to see the commands");
                    return false;
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("version")) {
                return new VersionCommand(this.plugin).displayVersion(sender);
            }
            if (args[0].equalsIgnoreCase("help")) {
                return new HelpCommand(this.plugin).showHelp(sender, args);
            }
            if (player == null) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_PLAYER");
                return false;
            }
            if (args[0].equalsIgnoreCase("stop_sound")) {
                return new StopSoundCommand(this.plugin).mute(player);
            }
            ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
            if (!rs.fromUUID(player.getUniqueId().toString())) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_A_TIMELORD");
                return true;
            }
            if (this.plugin.getTrackerKeeper().getInSiegeMode().contains(rs.getTardisId()) && tc.noSiege()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_NO_CMD");
                return true;
            }
            switch (tc) {
                case abandon: {
                    return new AbandonCommand(this.plugin).doAbandon(sender, args.length > 1);
                }
                case add: {
                    if (args.length == 1) {
                        return new AddCompanionCommand(this.plugin).doAddGUI(player);
                    }
                    return new AddCompanionCommand(this.plugin).doAdd(player, args);
                }
                case arch_time: {
                    return new TARDISArchCommand(this.plugin).getTime(player);
                }
                case archive: {
                    return new ArchiveCommand(this.plugin).zip(player, args);
                }
                case arsremove: {
                    return new ARSRemoveCommand(this.plugin).resetARS(player);
                }
                case bell: {
                    return new BellCommand(this.plugin).toggle(rs.getTardisId(), player, args);
                }
                case check_loc: {
                    return new CheckLocationCommand(this.plugin).doACheckLocation(player);
                }
                case colourise: 
                case colorize: {
                    return new ColouriseCommand(this.plugin).updateBeaconGlass(player);
                }
                case comehere: {
                    return new ComehereCommand(this.plugin).doComeHere(player);
                }
                case construct: {
                    return new ConstructCommand(this.plugin).setLine(player, args);
                }
                case cube: {
                    return new SiegeCubeCommand(this.plugin).whoHasCube(player);
                }
                case desktop: 
                case upgrade: 
                case theme: {
                    return new UpgradeCommand(this.plugin).openUpgradeGUI(player);
                }
                case direction: {
                    return new DirectionCommand(this.plugin).changeDirection(player, args);
                }
                case door: {
                    return new DoorCommand(this.plugin).toggleDoors(player, args);
                }
                case egg: {
                    return new ThemeMusicCommand(this.plugin).play(player, args);
                }
                case eject: {
                    return new EjectCommand(this.plugin).eject(player);
                }
                case excite: {
                    return new ExciteCommand(this.plugin).excite(player);
                }
                case ep1: {
                    return new EmergencyProgrammeOneCommand(this.plugin).showEP1(player);
                }
                case erase: {
                    return new DiskWriterCommand(this.plugin).eraseDisk(player);
                }
                case find: {
                    return new FindCommand(this.plugin).findTARDIS(player);
                }
                case handbrake: {
                    return new HandbrakeCommand(this.plugin).toggle(player, rs.getTardisId(), args, false);
                }
                case hide: {
                    return new HideCommand(this.plugin).hide((OfflinePlayer)player);
                }
                case sethome: {
                    return new SetHomeCommand(this.plugin).setHome(player, args);
                }
                case inside: {
                    return new InsideCommand(this.plugin).whosInside(player);
                }
                case item: {
                    return new ItemCommand(this.plugin).update(player, args);
                }
                case jettison: {
                    return new JettisonCommand(this.plugin).startJettison(player, args);
                }
                case lamps: {
                    return new LampsCommand(this.plugin).zip(player, args);
                }
                case list: {
                    return new ListCommand(this.plugin).doList(player, args);
                }
                case make_her_blue: {
                    return new MakeHerBlueCommand(this.plugin).show(player);
                }
                case monsters: {
                    return new MonstersCommand(this.plugin).reset(player, rs.getTardisId(), args);
                }
                case namekey: {
                    return new NameKeyCommand(this.plugin).nameKey(player, args);
                }
                case occupy: {
                    return new OccupyCommand(this.plugin).toggleOccupancy(player, args);
                }
                case decommission: {
                    return new DecommissionCommand(this.plugin).withdraw(player, args);
                }
                case rebuild: {
                    return new RebuildCommand(this.plugin).rebuildPreset((OfflinePlayer)player);
                }
                case remove: {
                    return new RemoveCompanionCommand(this.plugin).doRemoveCompanion(player, args);
                }
                case removesave: {
                    return new RemoveSavedLocationCommand(this.plugin).doRemoveSave(player, args);
                }
                case renamesave: {
                    return new RenameSavedLocationCommand(this.plugin).doRenameSave(player, args);
                }
                case reordersave: {
                    return new ReorderSavedLocationCommand(this.plugin).doReorderSave(player, args);
                }
                case rescue: {
                    return new RescueCommand(this.plugin).startRescue(player, args);
                }
                case room: {
                    return new RoomCommand(this.plugin).startRoom(player, args);
                }
                case save_player: {
                    ItemStack is = player.getInventory().getItemInMainHand();
                    if (this.heldDiskIsWrong(is, "Player Storage Disk")) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DISK_HAND_PLAYER");
                        return true;
                    }
                    return new DiskWriterCommand(this.plugin).writePlayer(player, args);
                }
                case secondary: {
                    return new SecondaryCommand(this.plugin).startSecondary(player, args);
                }
                case section: {
                    return new UpdateChatGUI(this.plugin).showInterface(player, args);
                }
                case setdest: {
                    return new SetDestinationCommand(this.plugin).doSetDestination(player, args);
                }
                case tagtheood: {
                    return new TagCommand(this.plugin).getStats(player);
                }
                case transmat: {
                    return new TransmatCommand(this.plugin).teleportOrProcess(player, args);
                }
                case update: {
                    return new UpdateCommand(this.plugin).startUpdate(player, args);
                }
                case abort: {
                    return new AbortCommand(this.plugin).doAbort(player, args, rs.getTardisId());
                }
                case exterminate: {
                    boolean messagePlayer = args.length != 2 || !args[1].equals("6z@3=V!Q7*/O_OB^");
                    return new ExterminateCommand(this.plugin).doExterminate(player, messagePlayer);
                }
                case save: {
                    if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(player.getUniqueId().toString(), SystemTree.SAVES)) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Saves");
                        return true;
                    }
                    ItemStack itemStack = player.getInventory().getItemInMainHand();
                    if (itemStack.getType().equals((Object)Material.MUSIC_DISC_FAR)) {
                        return new DiskWriterCommand(this.plugin).writeSaveToControlDisk(player, args);
                    }
                    if (this.plugin.getConfig().getBoolean("difficulty.disks") && !this.plugin.getUtils().inGracePeriod(player, true)) {
                        if (this.plugin.getConfig().getBoolean("difficulty.disk_in_hand_for_write") && this.heldDiskIsWrong(itemStack, "Save Storage Disk")) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "DISK_HAND_SAVE");
                            return true;
                        }
                        return new DiskWriterCommand(this.plugin).writeSave(player, args);
                    }
                    return new SaveLocationCommand(this.plugin).doSave(player, args);
                }
                case saveicon: {
                    return new SaveIconCommand(this.plugin).changeIcon((CommandSender)player, args);
                }
            }
        }
        return false;
    }

    private boolean heldDiskIsWrong(ItemStack is, String dn) {
        boolean complexBool = false;
        if (is == null) {
            complexBool = true;
        } else if (!is.hasItemMeta()) {
            complexBool = true;
        } else if (!is.getItemMeta().hasDisplayName()) {
            complexBool = true;
        } else if (!ComponentUtils.endsWith(is.getItemMeta().displayName(), dn)) {
            complexBool = true;
        }
        return complexBool;
    }
}

