/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.handles;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.handles.BrakeCommand;
import me.eccentric_nz.TARDIS.commands.handles.DiskCommand;
import me.eccentric_nz.TARDIS.commands.handles.LandCommand;
import me.eccentric_nz.TARDIS.commands.handles.LockUnlockCommand;
import me.eccentric_nz.TARDIS.commands.handles.RemindCommand;
import me.eccentric_nz.TARDIS.commands.handles.RemoveCommand;
import me.eccentric_nz.TARDIS.commands.handles.SayCommand;
import me.eccentric_nz.TARDIS.commands.handles.ScanCommand;
import me.eccentric_nz.TARDIS.commands.handles.TakeOffCommand;
import me.eccentric_nz.TARDIS.commands.handles.TellCommand;
import me.eccentric_nz.TARDIS.commands.handles.TimeCommand;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.handles.HandlesWeirdness;
import me.eccentric_nz.TARDIS.handles.wiki.HandlesWiki;
import me.eccentric_nz.TARDIS.handles.wiki.SearchDialog;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.dialog.DialogLike;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class TARDISHandlesCommand
implements CommandExecutor {
    private final TARDIS plugin;

    public TARDISHandlesCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length < 1) {
            return false;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            switch (args[0]) {
                case "wiki": {
                    if (args.length < 2) {
                        Audience.audience((Audience[])new Audience[]{player}).showDialog((DialogLike)new SearchDialog().create());
                        return true;
                    }
                    new HandlesWiki(this.plugin).getLinks(args[1], player);
                    return true;
                }
                case "disk": {
                    return new DiskCommand(this.plugin).renameDisk(player, args);
                }
                case "remove": {
                    return new RemoveCommand(this.plugin).purge(player);
                }
                case "weird": {
                    HandlesWeirdness.say(player);
                    return true;
                }
            }
        } else {
            UUID uuid;
            if (args[0].equals("wiki")) {
                this.plugin.getMessenger().send(sender, TardisModule.HANDLES, "HANDLES_NO_COMMAND");
                return true;
            }
            if (!sender.hasPermission("tardis.admin")) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_ADMIN");
                return true;
            }
            if (args.length < 2) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "HANDLES_INTERNAL");
                return true;
            }
            if (args[0].equals("tell")) {
                return new TellCommand(this.plugin).message(args);
            }
            try {
                uuid = args[0].equals("brake") ? UUID.fromString(args[2]) : UUID.fromString(args[1]);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "HANDLES_INTERNAL");
                return true;
            }
            Player player = this.plugin.getServer().getPlayer(uuid);
            switch (args[0]) {
                case "land": {
                    return new LandCommand(this.plugin).exitVortex(player, TARDISNumberParsers.parseInt(args[2]), args[1]);
                }
                case "lock": 
                case "unlock": {
                    return new LockUnlockCommand(this.plugin).toggleLock(player, TARDISNumberParsers.parseInt(args[2]), Boolean.parseBoolean(args[3]));
                }
                case "name": {
                    this.plugin.getMessenger().handlesSend(player, "HANDLES_NAME", player.getName());
                    return true;
                }
                case "remind": {
                    return new RemindCommand(this.plugin).doReminder(player, args);
                }
                case "say": {
                    return new SayCommand(this.plugin).say(player, args);
                }
                case "scan": {
                    return new ScanCommand(this.plugin, player, TARDISNumberParsers.parseInt(args[2])).sayScan();
                }
                case "takeoff": {
                    return new TakeOffCommand(this.plugin).enterVortex(player, args);
                }
                case "time": {
                    return new TimeCommand(this.plugin).sayTime(player);
                }
                case "brake": {
                    return new BrakeCommand(this.plugin).park(player, args);
                }
            }
        }
        return false;
    }
}

