/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.give;

import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.give.Give;
import me.eccentric_nz.TARDIS.commands.give.TARDISGiveTabComplete;
import me.eccentric_nz.TARDIS.commands.give.actions.Artron;
import me.eccentric_nz.TARDIS.commands.give.actions.FuelCell;
import me.eccentric_nz.TARDIS.commands.give.actions.Kit;
import me.eccentric_nz.TARDIS.commands.give.actions.Knowledge;
import me.eccentric_nz.TARDIS.commands.give.actions.Seed;
import me.eccentric_nz.TARDIS.commands.give.actions.SystemUpgrades;
import me.eccentric_nz.TARDIS.commands.give.actions.TARDISBlueprint;
import me.eccentric_nz.TARDIS.commands.give.actions.TARDISItem;
import me.eccentric_nz.TARDIS.commands.give.actions.TARDISRecipe;
import me.eccentric_nz.TARDIS.commands.give.actions.Tachyon;
import me.eccentric_nz.TARDIS.enumeration.Desktops;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.messaging.TARDISGiveLister;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class TARDISGiveCommand
implements CommandExecutor {
    private final TARDIS plugin;

    public TARDISGiveCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardisgive")) {
            if (sender instanceof ConsoleCommandSender || sender.hasPermission("tardis.admin")) {
                int amount;
                if (args.length == 1 && args[0].equalsIgnoreCase("list")) {
                    new TARDISGiveLister(this.plugin, sender).list();
                    return true;
                }
                if (args.length == 1 && args[0].equalsIgnoreCase("list_more")) {
                    new TARDISGiveLister(this.plugin, sender).listMore();
                    return true;
                }
                if (args.length < 3) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "TOO_FEW_ARGS");
                    this.plugin.getMessenger().message(sender, "/tardisgive [player] [item] [amount]");
                    return true;
                }
                String item = args[1].toLowerCase(Locale.ROOT);
                if (!Give.items.containsKey(item)) {
                    new TARDISGiveLister(this.plugin, sender).list();
                    return true;
                }
                switch (item) {
                    case "kit": {
                        Player p = this.plugin.getServer().getPlayer(args[0]);
                        if (p == null) {
                            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "COULD_NOT_FIND_NAME");
                            return true;
                        }
                        if (!this.plugin.getKitsConfig().contains("kits." + args[2])) {
                            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_KIT");
                            return true;
                        }
                        this.plugin.getKitsConfig().getStringList("kits." + args[2]).forEach(k -> new Kit(this.plugin).give((String)k, p));
                        this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "GIVE_KIT", sender.getName(), args[2]);
                        return true;
                    }
                    case "blueprint": {
                        String blueprint = args[2].toUpperCase(Locale.ROOT);
                        if (TARDISGiveTabComplete.getBlueprints().contains(blueprint)) {
                            new TARDISBlueprint(this.plugin).give(sender, args, blueprint);
                        } else {
                            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_BLUEPRINT");
                        }
                        return true;
                    }
                    case "recipes": {
                        if (args[2].equalsIgnoreCase("all")) {
                            new TARDISRecipe(this.plugin).grantMultiple(sender, args);
                        } else {
                            new TARDISRecipe(this.plugin).grant(sender, args);
                        }
                        return true;
                    }
                    case "seed": {
                        String seed = args[2].toUpperCase(Locale.ROOT);
                        if (!(!Desktops.getBY_NAMES().containsKey(seed) || seed.equals("SMALL") || seed.equals("MEDIUM") || seed.equals("TALL") || seed.equals("ARCHIVE"))) {
                            if (args.length > 3 && args[3].equalsIgnoreCase("knowledge")) {
                                Player sp = this.plugin.getServer().getPlayer(args[0]);
                                if (sp == null) {
                                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "COULD_NOT_FIND_NAME");
                                    return true;
                                }
                                new Knowledge(this.plugin).give(sender, seed.toLowerCase(Locale.ROOT) + "_seed", sp);
                            } else {
                                new Seed(this.plugin).give(sender, args);
                            }
                        } else {
                            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_SEED");
                        }
                        return true;
                    }
                    case "system-upgrade": {
                        return new SystemUpgrades(this.plugin).give(sender, args[0], args[2]);
                    }
                    case "tachyon": {
                        new Tachyon(this.plugin).give(sender, args[0], args[2]);
                        return true;
                    }
                }
                switch (args[2]) {
                    case "full": {
                        amount = this.plugin.getArtronConfig().getInt("full_charge");
                        break;
                    }
                    case "empty": {
                        amount = 0;
                        break;
                    }
                    case "knowledge": {
                        amount = 1;
                        break;
                    }
                    default: {
                        try {
                            amount = Integer.parseInt(args[2]);
                            break;
                        }
                        catch (NumberFormatException nfe) {
                            this.plugin.getMessenger().sendColouredCommand(sender, "ARG_GIVE", "/tardisgive [player] [item] [amount]", this.plugin);
                            return true;
                        }
                    }
                }
                if (item.equals("artron")) {
                    if (Bukkit.getOfflinePlayer((String)args[0]).getName() == null) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "COULD_NOT_FIND_NAME");
                        return true;
                    }
                    new Artron(this.plugin).give(sender, args[0], amount, args.length > 3 && args[3].equals("timelord"));
                    return true;
                }
                Player player = null;
                if (args[0].equals("@s") && sender instanceof Player) {
                    player = (Player)sender;
                } else if (args[0].equals("@p")) {
                    List near = Bukkit.selectEntities((CommandSender)sender, (String)"@p");
                    if (!near.isEmpty() && near.getFirst() instanceof Player && (player = (Player)near.getFirst()) == null) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "COULD_NOT_NEARBY_PLAYER");
                        return true;
                    }
                } else {
                    player = this.plugin.getServer().getPlayer(args[0]);
                }
                if (player == null) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "COULD_NOT_FIND_NAME");
                    return true;
                }
                if (args[1].equalsIgnoreCase("artron-storage-cell") && args.length == 4 && args[3].equalsIgnoreCase("full")) {
                    new FuelCell(this.plugin).give(sender, amount, player);
                    return true;
                }
                if (args[2].equals("knowledge")) {
                    if (item.equalsIgnoreCase("all")) {
                        new Knowledge(this.plugin).giveAll(sender, player);
                    } else {
                        new Knowledge(this.plugin).give(sender, item, player);
                    }
                    return true;
                }
                if (!args[2].endsWith("_seed")) {
                    return new TARDISItem(this.plugin).give(sender, item, amount, player);
                }
            } else {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NO_PERMS");
                return true;
            }
        }
        return false;
    }
}

