/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.builders.exterior;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.builders.exterior.InstantBlockPresetBuilder;
import me.eccentric_nz.TARDIS.builders.exterior.MaterialiseBlockPreset;
import me.eccentric_nz.TARDIS.builders.exterior.MaterialiseModelledPreset;
import me.eccentric_nz.TARDIS.chameleon.utils.TARDISChameleonCircuit;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.destroyers.InstantPresetDestroyer;
import me.eccentric_nz.TARDIS.enumeration.Adaption;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.junk.JunkBuilder;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class PresetBuilderFactory {
    final List<ChameleonPreset> no_block_under_door;
    private final TARDIS plugin;
    private final HashMap<COMPASS, BlockFace[]> face_map = new HashMap();
    private final List<ChameleonPreset> notSubmarinePresets;

    public PresetBuilderFactory(TARDIS plugin) {
        this.plugin = plugin;
        this.face_map.put(COMPASS.SOUTH, new BlockFace[]{BlockFace.SOUTH_WEST, BlockFace.SOUTH_SOUTH_WEST, BlockFace.SOUTH, BlockFace.SOUTH_SOUTH_EAST, BlockFace.SOUTH_EAST});
        this.face_map.put(COMPASS.EAST, new BlockFace[]{BlockFace.SOUTH_EAST, BlockFace.EAST_SOUTH_EAST, BlockFace.EAST, BlockFace.EAST_NORTH_EAST, BlockFace.NORTH_EAST});
        this.face_map.put(COMPASS.NORTH, new BlockFace[]{BlockFace.NORTH_EAST, BlockFace.NORTH_NORTH_EAST, BlockFace.NORTH, BlockFace.NORTH_NORTH_WEST, BlockFace.NORTH_WEST});
        this.face_map.put(COMPASS.WEST, new BlockFace[]{BlockFace.NORTH_WEST, BlockFace.WEST_NORTH_WEST, BlockFace.WEST, BlockFace.WEST_SOUTH_WEST, BlockFace.SOUTH_WEST});
        this.no_block_under_door = new ArrayList<ChameleonPreset>();
        this.no_block_under_door.add(ChameleonPreset.ANGEL);
        this.no_block_under_door.add(ChameleonPreset.DUCK);
        this.no_block_under_door.add(ChameleonPreset.GAZEBO);
        this.no_block_under_door.add(ChameleonPreset.HELIX);
        this.no_block_under_door.add(ChameleonPreset.LIBRARY);
        this.no_block_under_door.add(ChameleonPreset.ROBOT);
        this.no_block_under_door.add(ChameleonPreset.SWAMP);
        this.no_block_under_door.add(ChameleonPreset.TORCH);
        this.no_block_under_door.add(ChameleonPreset.WELL);
        this.notSubmarinePresets = new ArrayList<ChameleonPreset>();
        this.notSubmarinePresets.add(ChameleonPreset.LAMP);
        this.notSubmarinePresets.add(ChameleonPreset.MINESHAFT);
    }

    public void buildPreset(BuildData bd) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", bd.getTardisID());
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            Biome biome;
            Tardis tardis = rs.getTardis();
            ChameleonPreset preset = tardis.getPreset();
            Chunk thisChunk = bd.getLocation().getChunk();
            while (!thisChunk.isLoaded()) {
                thisChunk.load();
            }
            if (bd.isRebuild()) {
                biome = bd.getLocation().getBlock().getRelative(this.getOppositeFace(bd.getDirection().forPreset()), 2).getBiome();
            } else {
                biome = bd.getLocation().getBlock().getBiome();
                if (this.plugin.getTrackerKeeper().getActiveForceFields().containsKey(tardis.getUuid())) {
                    this.plugin.getTrackerKeeper().getActiveForceFields().remove(tardis.getUuid());
                    this.plugin.getMessenger().send((CommandSender)bd.getPlayer().getPlayer(), TardisModule.TARDIS, "FORCE_FIELD", "OFF");
                }
            }
            if (tardis.getAdaption().equals((Object)Adaption.BIOME)) {
                preset = this.adapt(biome, tardis.getAdaption());
            }
            ChameleonPreset demat = tardis.getDemat();
            Material chameleonMaterial = Material.LIGHT_GRAY_TERRACOTTA;
            if (tardis.getAdaption().equals((Object)Adaption.BIOME) && preset.equals((Object)ChameleonPreset.FACTORY) || tardis.getAdaption().equals((Object)Adaption.BLOCK) || preset.equals((Object)ChameleonPreset.SUBMERGED)) {
                Block chameleonBlock = bd.getLocation().getBlock().getType() == Material.SNOW ? bd.getLocation().getBlock() : bd.getLocation().getBlock().getRelative(BlockFace.DOWN);
                TARDISChameleonCircuit tcc = new TARDISChameleonCircuit(this.plugin);
                chameleonMaterial = tcc.getChameleonBlock(chameleonBlock, bd.getPlayer());
            }
            boolean hidden = tardis.isHidden();
            if (bd.isSubmarine() && this.notSubmarinePresets.contains((Object)preset)) {
                preset = ChameleonPreset.YELLOW;
                this.plugin.getMessenger().send((CommandSender)bd.getPlayer().getPlayer(), TardisModule.TARDIS, "SUB_UNSUITED");
            }
            while (!thisChunk.isLoaded()) {
                thisChunk.load();
            }
            if (this.plugin.getConfig().getBoolean("police_box.keep_chunk_force_loaded")) {
                thisChunk.addPluginChunkTicket((Plugin)this.plugin);
            }
            if (bd.isRebuild()) {
                bd.setThrottle(SpaceTimeThrottle.REBUILD);
                if (!hidden) {
                    InstantPresetDestroyer deinsta = new InstantPresetDestroyer(this.plugin);
                    deinsta.instaDestroyPreset(bd, false, demat);
                }
                this.plugin.getTrackerKeeper().getMaterialising().add(bd.getTardisID());
                if (preset.usesArmourStand()) {
                    MaterialiseModelledPreset stand = new MaterialiseModelledPreset(this.plugin, bd, preset);
                    taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)stand, 10L, 20L);
                    stand.setTask(taskID);
                } else {
                    MaterialiseBlockPreset runnable = new MaterialiseBlockPreset(this.plugin, bd, preset, chameleonMaterial.createBlockData(), tardis.getAdaption());
                    taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, 10L, 20L);
                    runnable.setTask(taskID);
                }
                TARDISSounds.playTARDISSound(bd.getLocation(), "tardis_land_fast");
                if (bd.getPlayer().getPlayer() != null && this.plugin.getUtils().inTARDISWorld(bd.getPlayer().getPlayer())) {
                    TARDISSounds.playTARDISSound(bd.getPlayer().getPlayer().getLocation(), "tardis_land_fast");
                }
            } else if (!preset.equals((Object)ChameleonPreset.INVISIBLE)) {
                this.plugin.getTrackerKeeper().getMaterialising().add(bd.getTardisID());
                if (preset.equals((Object)ChameleonPreset.JUNK)) {
                    JunkBuilder runnable = new JunkBuilder(this.plugin, bd);
                    int taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, 10L, 20L);
                    runnable.setTask(taskID);
                } else if (preset.usesArmourStand()) {
                    MaterialiseModelledPreset stand = new MaterialiseModelledPreset(this.plugin, bd, preset);
                    taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)stand, 10L, 20L);
                    stand.setTask(taskID);
                } else {
                    MaterialiseBlockPreset runnable = new MaterialiseBlockPreset(this.plugin, bd, preset, chameleonMaterial.createBlockData(), tardis.getAdaption());
                    taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, 10L, 20L);
                    runnable.setTask(taskID);
                }
            } else {
                Material material = chameleonMaterial;
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    this.plugin.getTrackerKeeper().getMaterialising().add(bd.getTardisID());
                    new InstantBlockPresetBuilder(this.plugin, bd, ChameleonPreset.INVISIBLE, material.createBlockData(), false).buildPreset();
                }, 375L);
            }
            HashMap<String, Object> whered = new HashMap<String, Object>();
            whered.put("tardis_id", bd.getTardisID());
            HashMap<String, Object> set = new HashMap<String, Object>();
            if (preset == ChameleonPreset.ITEM) {
                set.put("chameleon_demat", "ITEM:" + tardis.getItemPreset());
            } else {
                set.put("chameleon_demat", preset.toString());
            }
            this.plugin.getQueryFactory().doUpdate("tardis", set, whered);
        }
    }

    private ChameleonPreset adapt(Biome biome, Adaption adaption) {
        if (adaption.equals((Object)Adaption.BLOCK)) {
            return ChameleonPreset.ADAPTIVE;
        }
        try {
            return ChameleonPreset.valueOf(this.plugin.getAdaptiveConfig().getString(biome.key().value().toUpperCase(Locale.ROOT)));
        }
        catch (IllegalArgumentException e) {
            return ChameleonPreset.FACTORY;
        }
    }

    public BlockFace getSkullDirection(COMPASS d) {
        BlockFace[] faces = this.face_map.get((Object)d);
        return faces[TARDISConstants.RANDOM.nextInt(5)];
    }

    public BlockFace getOppositeFace(COMPASS d) {
        return switch (d) {
            case COMPASS.SOUTH -> BlockFace.NORTH;
            case COMPASS.WEST -> BlockFace.EAST;
            case COMPASS.NORTH -> BlockFace.SOUTH;
            default -> BlockFace.WEST;
        };
    }
}

