/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.artron.costs;

import java.io.File;
import java.io.IOException;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.artron.costs.ArtronValues;
import me.eccentric_nz.TARDIS.artron.costs.Calculator;
import me.eccentric_nz.TARDIS.artron.costs.CostData;
import me.eccentric_nz.TARDIS.artron.costs.Processor;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;

public class UpgradeCostSetter {
    private final TARDIS plugin;

    public UpgradeCostSetter(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void calculate() {
        ArtronValues artronValues = new Processor(this.plugin).getValues();
        for (CostData data : artronValues.calculated()) {
            int cost = Calculator.getMapped(data, artronValues.highest());
            this.plugin.getArtronConfig().set("upgrades." + TARDISStringUtils.toUnderscoredLowercase(data.name()), (Object)cost);
        }
        try {
            this.plugin.getArtronConfig().save(new File(this.plugin.getDataFolder(), "artron.yml"));
            this.plugin.debug("Updated desktop upgrades in artron.yml");
        }
        catch (IOException io) {
            this.plugin.debug("Could not save artron.yml, " + String.valueOf(io));
        }
    }
}

