/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.artron.actions;

import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetArtronStorage;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ArtronChargeAction {
    private final TARDIS plugin;

    public ArtronChargeAction(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void add(Player player, Material item, Material full, Location location, int current_level, int id) {
        int amount = 0;
        int fc = this.plugin.getArtronConfig().getInt("full_charge");
        if (item.equals((Object)full)) {
            if (this.plugin.getConfig().getBoolean("preferences.no_creative_condense")) {
                switch (this.plugin.getWorldManager()) {
                    case MULTIVERSE: {
                        if (this.plugin.getMVHelper().isWorldSurvival(location.getWorld())) break;
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARTRON_FULL_CREATIVE");
                        return;
                    }
                    case NONE: {
                        if (!this.plugin.getPlanetsConfig().getString("planets." + location.getWorld().getName() + ".gamemode").equalsIgnoreCase("CREATIVE")) break;
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARTRON_FULL_CREATIVE");
                        return;
                    }
                }
            }
            int a = player.getInventory().getItemInMainHand().getAmount();
            int a2 = a - 1;
            if (current_level < fc) {
                amount = fc;
                if (a2 > 0) {
                    player.getInventory().getItemInMainHand().setAmount(a2);
                } else {
                    player.getInventory().removeItem(new ItemStack[]{ItemStack.of((Material)full, (int)1)});
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ENERGY_AT_MAX");
            } else {
                amount = current_level;
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ENERGY_MAX");
            }
        } else {
            ItemStack is = player.getInventory().getItemInMainHand();
            if (is.hasItemMeta()) {
                ItemMeta im = is.getItemMeta();
                String name = ComponentUtils.stripColour(im.displayName());
                if (!name.endsWith("Artron Storage Cell")) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CELL_NOT_VALID");
                    return;
                }
                List lore = im.lore();
                int charge = TARDISNumberParsers.parseInt(ComponentUtils.stripColour((Component)lore.get(1)));
                if (charge <= 0) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CELL_NOT_CHARGED");
                    return;
                }
                ResultSetArtronStorage rsas = new ResultSetArtronStorage(this.plugin);
                if (!rsas.fromID(id)) {
                    return;
                }
                int damage = fc / 2 * rsas.getDamageCount();
                int max = fc * rsas.getCapacitorCount() - damage;
                amount = current_level + (charge *= is.getAmount());
                if (is.getAmount() == 1 && amount > max) {
                    if (current_level >= max) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CAPACITOR_TRANSFER", max);
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CAPACITOR_ADD");
                        return;
                    }
                    amount = max;
                    int remove = max - current_level;
                    int set = charge - remove;
                    lore.set(1, Component.text((int)set));
                    im.lore(lore);
                    if (set < 1) {
                        im.setEnchantmentGlintOverride(null);
                        is.getEnchantments().keySet().forEach(arg_0 -> ((ItemStack)is).removeEnchantment(arg_0));
                    }
                    is.setItemMeta(im);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CELL_TRANSFER");
                } else if (amount <= max) {
                    lore.set(1, Component.text((String)"0"));
                    im.lore(lore);
                    im.setEnchantmentGlintOverride(null);
                    is.setItemMeta(im);
                    is.getEnchantments().keySet().forEach(arg_0 -> ((ItemStack)is).removeEnchantment(arg_0));
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CELL_TRANSFER");
                } else {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CAPACITOR_TRANSFER", max);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CAPACITOR_ADD");
                    return;
                }
            }
        }
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("artron_level", amount);
        HashMap<String, Object> whereid = new HashMap<String, Object>();
        whereid.put("tardis_id", id);
        this.plugin.getQueryFactory().doUpdate("tardis", set, whereid);
    }
}

