/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.arch.ArchPersister;
import me.eccentric_nz.TARDIS.builders.utility.SeedBlockPersister;
import me.eccentric_nz.TARDIS.camera.CameraPersister;
import me.eccentric_nz.TARDIS.database.TimeRotorLoader;
import me.eccentric_nz.TARDIS.desktop.PreviewPersister;
import me.eccentric_nz.TARDIS.flight.FlightPersister;
import me.eccentric_nz.TARDIS.flight.VortexPersister;
import me.eccentric_nz.TARDIS.forcefield.ForceFieldPersister;
import me.eccentric_nz.TARDIS.hads.HadsPersister;
import me.eccentric_nz.TARDIS.move.PortalPersister;
import me.eccentric_nz.TARDIS.rooms.RoomPersister;
import me.eccentric_nz.TARDIS.rooms.games.ArcadePersister;
import me.eccentric_nz.TARDIS.rooms.games.ArcadeTracker;
import me.eccentric_nz.TARDIS.sensor.SensorTracker;
import me.eccentric_nz.TARDIS.siegemode.SiegePersister;
import me.eccentric_nz.TARDIS.skins.SkinPersister;
import me.eccentric_nz.TARDIS.utility.JunkPlayerPersister;
import me.eccentric_nz.tardisweepingangels.nms.FollowerSaver;

public class TARDISPersister {
    private final TARDIS plugin;

    public TARDISPersister(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void load() {
        new PortalPersister(this.plugin).load();
        if (this.plugin.isDisguisesOnServer() && this.plugin.getConfig().getBoolean("arch.enabled")) {
            new ArchPersister(this.plugin).checkAll();
        }
        if (this.plugin.getConfig().getBoolean("siege.enabled")) {
            SiegePersister tsp = new SiegePersister(this.plugin);
            tsp.loadSiege();
            tsp.loadCubes();
        }
        if (this.plugin.getConfig().getBoolean("allow.hads")) {
            HadsPersister thp = new HadsPersister(this.plugin);
            thp.load();
        }
        if (this.plugin.getConfig().getInt("allow.force_field") > 0) {
            new ForceFieldPersister(this.plugin).load();
        }
        if (this.plugin.getConfig().getBoolean("desktop.previews")) {
            new PreviewPersister(this.plugin).load();
        }
        new TimeRotorLoader(this.plugin).load();
        new VortexPersister(this.plugin).load();
        new FlightPersister(this.plugin).load();
        new CameraPersister(this.plugin).load();
        new JunkPlayerPersister(this.plugin).load();
        new SeedBlockPersister(this.plugin).load();
        new RoomPersister(this.plugin).resume();
        new SkinPersister(this.plugin).load();
        SensorTracker.restartCharging(this.plugin);
    }

    public void save() {
        if (!ArcadeTracker.PLAYERS.isEmpty()) {
            new ArcadePersister(this.plugin).save();
        }
        new RoomPersister(this.plugin).saveProgress();
        new PortalPersister(this.plugin).save();
        if (this.plugin.isDisguisesOnServer() && this.plugin.getConfig().getBoolean("arch.enabled")) {
            new ArchPersister(this.plugin).saveAll();
        }
        if (this.plugin.getConfig().getBoolean("siege.enabled")) {
            new SiegePersister(this.plugin).saveCubes();
        }
        if (this.plugin.getConfig().getBoolean("desktop.previews")) {
            new PreviewPersister(this.plugin).save();
        }
        if (this.plugin.getConfig().getBoolean("allow.hads")) {
            new HadsPersister(this.plugin).save();
        }
        new VortexPersister(this.plugin).save();
        new FlightPersister(this.plugin).save();
        new CameraPersister(this.plugin).save();
        if (this.plugin.getConfig().getInt("allow.force_field") > 0) {
            new ForceFieldPersister(this.plugin).save();
        }
        new SeedBlockPersister(this.plugin).save();
        if (this.plugin.getConfig().getBoolean("modules.weeping_angels")) {
            new FollowerSaver(this.plugin).persist();
        }
        new SkinPersister(this.plugin).save();
    }
}

