/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.utils;

import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.custommodels.keys.AngelOfLibertyVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.ArmourVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.CybermanVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.DalekSecVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.DalekVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.DavrosVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.DroidVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.EmptyChildVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.HathVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.HeavenlyHostVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.IceWarriorVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.JudoonVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.K9Variant;
import me.eccentric_nz.TARDIS.custommodels.keys.MireVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.MonkVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.NimonVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.OmegaVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.OodVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.OssifiedVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.RacnossVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.ScarecrowVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.SeaDevilVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.SilentVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.SilurianVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.SlitheenVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.SmilerVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.SontaranVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.StraxVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.SutekhVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.SycoraxVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.TheBeastVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.ToclafaneVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.VampireOfVeniceVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.VashtaNeradaVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.WeepingAngelVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.ZygonVariant;
import me.eccentric_nz.TARDIS.skins.CharacterSkins;
import me.eccentric_nz.TARDIS.skins.CyberSkins;
import me.eccentric_nz.TARDIS.skins.MonsterSkins;
import me.eccentric_nz.TARDIS.skins.Skin;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.EntityType;

public enum Monster {
    ANGEL_OF_LIBERTY("Angel Of Liberty", EntityType.ZOMBIE, "liberty", AngelOfLibertyVariant.ANGEL_OF_LIBERTY_STATIC.getKey(), Material.OXIDIZED_COPPER_GRATE, AngelOfLibertyVariant.ANGEL_OF_LIBERTY_HEAD.getKey(), MonsterSkins.ANGEL_OF_LIBERTY),
    CLOCKWORK_DROID("Clockwork Droid", EntityType.ZOMBIE, "clockwork", DroidVariant.CLOCKWORK_DROID_STATIC.getKey(), Material.HOST_ARMOR_TRIM_SMITHING_TEMPLATE, DroidVariant.CLOCKWORK_DROID_HEAD.getKey(), MonsterSkins.CLOCKWORK_DROID_MALE),
    CYBERMAN("Cyberman", EntityType.ZOMBIE, "cyberman", CybermanVariant.CYBERMAN_STATIC.getKey(), Material.IRON_INGOT, CybermanVariant.CYBERMAN_HEAD.getKey(), CyberSkins.CYBERMAN),
    CYBERSHADE("Cybershade", EntityType.ZOMBIE, "cybershade", CybermanVariant.CYBERSHADE_STATIC.getKey(), Material.BROWN_WOOL, CybermanVariant.CYBERSHADE_HEAD.getKey(), CyberSkins.CYBERSHADE),
    DALEK("Dalek", EntityType.SKELETON, "dalek", DalekVariant.DALEK_BRASS.getKey(), Material.SLIME_BALL, DalekVariant.DALEK_HEAD.getKey(), null),
    DALEK_SEC("Dalek Sec", EntityType.ZOMBIFIED_PIGLIN, "dalek_sec", DalekSecVariant.DALEK_SEC_STATIC.getKey(), Material.MANGROVE_PROPAGULE, DalekSecVariant.DALEK_SEC_HEAD.getKey(), CharacterSkins.DALEK_SEC),
    DAVROS("Davros", EntityType.ZOMBIFIED_PIGLIN, "davros", DavrosVariant.DAVROS.getKey(), Material.CRIMSON_BUTTON, DavrosVariant.DAVROS_HEAD.getKey(), null),
    EMPTY_CHILD("Empty Child", EntityType.ZOMBIE, "empty", EmptyChildVariant.EMPTY_CHILD_STATIC.getKey(), Material.SUGAR, EmptyChildVariant.EMPTY_CHILD_HEAD.getKey(), MonsterSkins.EMPTY_CHILD),
    HATH("Hath", EntityType.ZOMBIFIED_PIGLIN, "hath", HathVariant.HATH_STATIC.getKey(), Material.PUFFERFISH, HathVariant.HATH_HEAD.getKey(), null),
    HEADLESS_MONK("Headless Monk", EntityType.SKELETON, "monk", MonkVariant.HEADLESS_MONK_STATIC.getKey(), Material.RED_CANDLE, MonkVariant.HEADLESS_MONK_HEAD.getKey(), MonsterSkins.HEADLESS_MONK),
    HEAVENLY_HOST("Heavenly Host", EntityType.ZOMBIE, "heavenly_host", HeavenlyHostVariant.HEAVENLY_HOST_STATIC.getKey(), Material.GOLD_INGOT, HeavenlyHostVariant.HEAVENLY_HOST_HEAD.getKey(), MonsterSkins.HEAVENLY_HOST),
    ICE_WARRIOR("Ice Warrior", EntityType.ZOMBIFIED_PIGLIN, "ice", IceWarriorVariant.ICE_WARRIOR_STATIC.getKey(), Material.SNOWBALL, IceWarriorVariant.ICE_WARRIOR_HEAD.getKey(), MonsterSkins.ICE_WARRIOR),
    JUDOON("Judoon", EntityType.HUSK, "judoon", JudoonVariant.JUDOON_STATIC.getKey(), Material.YELLOW_DYE, JudoonVariant.JUDOON_HEAD.getKey(), CharacterSkins.JUDOON),
    K9("K9", EntityType.HUSK, "k9", K9Variant.K9.getKey(), Material.BONE, null, null),
    MIRE("Mire", EntityType.SKELETON, "mire", MireVariant.THE_MIRE_STATIC.getKey(), Material.NETHERITE_SCRAP, MireVariant.THE_MIRE_HEAD.getKey(), null),
    NIMON("Nimon", EntityType.ZOMBIE, "nimon", NimonVariant.NIMON_STATIC.getKey(), Material.BEEF, NimonVariant.NIMON_HEAD.getKey(), MonsterSkins.NIMON),
    OMEGA("Omega", EntityType.SKELETON, "omega", OmegaVariant.OMEGA_STATIC.getKey(), Material.GOLD_INGOT, OmegaVariant.OMEGA_HEAD.getKey(), MonsterSkins.OMEGA),
    OOD("Ood", EntityType.HUSK, "ood", OodVariant.OOD_BLACK_STATIC.getKey(), Material.ROTTEN_FLESH, OodVariant.OOD_HEAD.getKey(), CharacterSkins.OOD),
    OSSIFIED("Ossified Time Zombie", EntityType.ZOMBIE, "ossified", OssifiedVariant.OSSIFIED_STATIC.getKey(), Material.CHARCOAL, OssifiedVariant.OSSIFIED_HEAD.getKey(), null),
    RACNOSS("Racnoss", EntityType.PIGLIN_BRUTE, "racnoss", RacnossVariant.RACNOSS_STATIC.getKey(), Material.SPIDER_EYE, RacnossVariant.RACNOSS_HEAD.getKey(), MonsterSkins.RACNOSS),
    SATURNYNIAN("Saturnynian", EntityType.DROWNED, "saturnynian", VampireOfVeniceVariant.SATURNYNIAN_STATIC.getKey(), Material.COD, VampireOfVeniceVariant.SATURNYNIAN_MONSTER_HEAD.getKey(), MonsterSkins.SATURNYNIAN),
    SCARECROW("Scarecrow", EntityType.ZOMBIE, "scarecrow", ScarecrowVariant.SCARECROW_STATIC.getKey(), Material.WHEAT, ScarecrowVariant.SCARECROW_HEAD.getKey(), MonsterSkins.SCARECROW),
    SEA_DEVIL("Sea Devil", EntityType.DROWNED, "devil", SeaDevilVariant.SEA_DEVIL_STATIC.getKey(), Material.KELP, SeaDevilVariant.SEA_DEVIL_HEAD.getKey(), MonsterSkins.SEA_DEVIL),
    SILENT("Silent", EntityType.SKELETON, "silent", SilentVariant.SILENT_STATIC.getKey(), Material.END_STONE, SilentVariant.SILENT_HEAD.getKey(), MonsterSkins.SILENCE),
    SILURIAN("Silurian", EntityType.SKELETON, "silurian", SilurianVariant.SILURIAN_STATIC.getKey(), Material.FEATHER, SilurianVariant.SILURIAN_HEAD.getKey(), MonsterSkins.SILURIAN),
    SLITHEEN("Slitheen", EntityType.ZOMBIE, "slitheen", SlitheenVariant.SLITHEEN_STATIC.getKey(), Material.TURTLE_EGG, SlitheenVariant.SLITHEEN_HEAD.getKey(), MonsterSkins.SLITHEEN),
    SMILER("Smiler", EntityType.ZOMBIE, "smiler", SmilerVariant.SMILER_STATIC.getKey(), Material.RED_STAINED_GLASS_PANE, SmilerVariant.SMILER_HEAD.getKey(), MonsterSkins.SMILER),
    SONTARAN("Sontaran", EntityType.ZOMBIE, "sontaran", SontaranVariant.SONTARAN_STATIC.getKey(), Material.POTATO, SontaranVariant.SONTARAN_HEAD.getKey(), MonsterSkins.SONTARAN),
    STRAX("Strax", EntityType.ZOMBIFIED_PIGLIN, "strax", StraxVariant.STRAX_STATIC.getKey(), Material.BAKED_POTATO, StraxVariant.STRAX_HEAD.getKey(), null),
    SUTEKH("Sutekh", EntityType.STRAY, "sutekh", SutekhVariant.SUTEKH_STATIC.getKey(), Material.DUNE_ARMOR_TRIM_SMITHING_TEMPLATE, SutekhVariant.SUTEKH_HEAD.getKey(), MonsterSkins.SUTEKH),
    SYCORAX("Sycorax", EntityType.ZOMBIE, "sycorax", SycoraxVariant.SYCORAX_STATIC.getKey(), Material.BONE_MEAL, SycoraxVariant.SYCORAX_HEAD.getKey(), MonsterSkins.SYCORAX),
    THE_BEAST("The Beast", EntityType.ZOMBIE, "beast", TheBeastVariant.THE_BEAST_STATIC.getKey(), Material.FIRE_CHARGE, TheBeastVariant.THE_BEAST_HEAD.getKey(), MonsterSkins.THE_BEAST),
    TOCLAFANE("Toclafane", EntityType.ZOMBIE, "toclafane", ToclafaneVariant.TOCLAFANE.getKey(), Material.GUNPOWDER, null, null),
    VAMPIRE_OF_VENICE("Vampire Of Venice", EntityType.DROWNED, "vampire", VampireOfVeniceVariant.VAMPIRE_STATIC.getKey(), Material.COD, VampireOfVeniceVariant.VAMPIRE_HEAD.getKey(), MonsterSkins.VAMPIRE_OF_VENICE),
    VASHTA_NERADA("Vashta Nerada", EntityType.ZOMBIE, "vashta", VashtaNeradaVariant.VASHTA_NERADA_STATIC.getKey(), Material.BOOK, VashtaNeradaVariant.VASHTA_NERADA_HEAD.getKey(), MonsterSkins.VASHTA_NERADA),
    WEEPING_ANGEL("Weeping Angel", EntityType.SKELETON, "angel", WeepingAngelVariant.WEEPING_ANGEL_STATIC.getKey(), Material.BRICK, WeepingAngelVariant.WEEPING_ANGEL_PLAYER_HEAD.getKey(), MonsterSkins.WEEPING_ANGEL),
    ZYGON("Zygon", EntityType.ZOMBIE, "zygon", ZygonVariant.ZYGON_STATIC.getKey(), Material.PAINTING, ZygonVariant.ZYGON_HEAD.getKey(), MonsterSkins.ZYGON);

    private final String name;
    private final EntityType entityType;
    private final String permission;
    private final NamespacedKey model;
    private final Material material;
    private final NamespacedKey headModel;
    private final Skin skin;
    private final List<NamespacedKey> cyberVariants = new ArrayList<NamespacedKey>();

    private Monster(String name, EntityType entityType, String permission, NamespacedKey model, Material material, NamespacedKey headModel, Skin skin) {
        this.name = name;
        this.entityType = entityType;
        this.permission = permission;
        this.model = model;
        this.material = material;
        this.headModel = headModel;
        this.skin = skin;
        this.cyberVariants.add(ArmourVariant.CYBERMAN.getKey());
        this.cyberVariants.add(ArmourVariant.BLACK_CYBERMAN.getKey());
        this.cyberVariants.add(ArmourVariant.CYBERMAN_EARTHSHOCK.getKey());
        this.cyberVariants.add(ArmourVariant.CYBERMAN_INVASION.getKey());
        this.cyberVariants.add(ArmourVariant.CYBERMAN_MOONBASE.getKey());
        this.cyberVariants.add(ArmourVariant.CYBERMAN_RISE.getKey());
        this.cyberVariants.add(ArmourVariant.CYBERMAN_TENTH_PLANET.getKey());
        this.cyberVariants.add(ArmourVariant.CYBER_LORD.getKey());
        this.cyberVariants.add(ArmourVariant.WOOD_CYBERMAN.getKey());
        this.cyberVariants.add(ArmourVariant.CYBERSHADE.getKey());
    }

    public String getName() {
        return this.name;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public String getPermission() {
        return this.permission;
    }

    public NamespacedKey getModel() {
        if (this == DALEK) {
            return switch (TARDISConstants.RANDOM.nextInt(17)) {
                case 15 -> DalekVariant.DALEK_BLACK.getKey();
                case 14 -> DalekVariant.DALEK_RED.getKey();
                case 13 -> DalekVariant.DALEK_GREEN.getKey();
                case 12 -> DalekVariant.DALEK_BROWN.getKey();
                case 11 -> DalekVariant.DALEK_BLUE.getKey();
                case 10 -> DalekVariant.DALEK_PURPLE.getKey();
                case 9 -> DalekVariant.DALEK_CYAN.getKey();
                case 8 -> DalekVariant.DALEK_LIGHT_GRAY.getKey();
                case 7 -> DalekVariant.DALEK_GRAY.getKey();
                case 6 -> DalekVariant.DALEK_PINK.getKey();
                case 5 -> DalekVariant.DALEK_LIME.getKey();
                case 4 -> DalekVariant.DALEK_YELLOW.getKey();
                case 3 -> DalekVariant.DALEK_LIGHT_BLUE.getKey();
                case 2 -> DalekVariant.DALEK_MAGENTA.getKey();
                case 1 -> DalekVariant.DALEK_ORANGE.getKey();
                case 0 -> DalekVariant.DALEK_WHITE.getKey();
                default -> DalekVariant.DALEK_BRASS.getKey();
            };
        }
        return this.model;
    }

    public Material getMaterial() {
        return this.material;
    }

    public NamespacedKey getHeadModel() {
        return this.headModel;
    }

    public boolean isFollower() {
        switch (this.ordinal()) {
            case 12: 
            case 13: 
            case 17: {
                return true;
            }
        }
        return false;
    }

    public Skin getSkin() {
        return this.skin;
    }

    public NamespacedKey getArmourKey() {
        NamespacedKey key = null;
        switch (this.ordinal()) {
            case 0: {
                key = ArmourVariant.ANGEL_OF_LIBERTY.getKey();
                break;
            }
            case 1: {
                if (TARDISConstants.RANDOM.nextBoolean()) {
                    key = ArmourVariant.CLOCKWORK_DROID.getKey();
                    break;
                }
                key = ArmourVariant.CLOCKWORK_DROID_FEMALE.getKey();
                break;
            }
            case 2: {
                key = this.cyberVariants.get(TARDISConstants.RANDOM.nextInt(this.cyberVariants.size()));
                break;
            }
            case 3: {
                key = ArmourVariant.CYBERSHADE.getKey();
                break;
            }
            case 5: {
                key = ArmourVariant.DALEK_SEC.getKey();
                break;
            }
            case 7: {
                key = ArmourVariant.EMPTY_CHILD.getKey();
                break;
            }
            case 8: {
                key = ArmourVariant.HATH.getKey();
                break;
            }
            case 9: {
                key = ArmourVariant.HEADLESS_MONK.getKey();
                break;
            }
            case 10: {
                key = ArmourVariant.HEAVENLY_HOST.getKey();
                break;
            }
            case 11: {
                key = ArmourVariant.ICE_WARRIOR.getKey();
                break;
            }
            case 12: {
                key = ArmourVariant.JUDOON.getKey();
                break;
            }
            case 14: {
                key = ArmourVariant.MIRE.getKey();
                break;
            }
            case 15: {
                key = ArmourVariant.NIMON.getKey();
                break;
            }
            case 17: {
                int r = TARDISConstants.RANDOM.nextInt(100);
                if (r < 15) {
                    key = ArmourVariant.OOD_BLUE.getKey();
                    break;
                }
                if (r > 84) {
                    key = ArmourVariant.OOD_BROWN.getKey();
                    break;
                }
                key = ArmourVariant.OOD_BLACK.getKey();
                break;
            }
            case 16: {
                key = ArmourVariant.OMEGA.getKey();
                break;
            }
            case 18: {
                key = ArmourVariant.OSSIFIED.getKey();
                break;
            }
            case 19: {
                key = ArmourVariant.RACNOSS.getKey();
                break;
            }
            case 20: {
                key = ArmourVariant.SATURNYNIAN.getKey();
                break;
            }
            case 21: {
                key = ArmourVariant.SCARECROW.getKey();
                break;
            }
            case 22: {
                key = ArmourVariant.SEA_DEVIL.getKey();
                break;
            }
            case 23: {
                key = ArmourVariant.SILENCE.getKey();
                break;
            }
            case 24: {
                key = ArmourVariant.SILURIAN.getKey();
                break;
            }
            case 25: {
                key = ArmourVariant.SLITHEEN.getKey();
                break;
            }
            case 26: {
                key = ArmourVariant.SMILER.getKey();
                break;
            }
            case 27: {
                key = ArmourVariant.SONTARAN.getKey();
                break;
            }
            case 28: {
                key = ArmourVariant.STRAX.getKey();
                break;
            }
            case 29: {
                key = ArmourVariant.SUTEKH.getKey();
                break;
            }
            case 30: {
                key = ArmourVariant.SYCORAX.getKey();
                break;
            }
            case 31: {
                key = ArmourVariant.THE_BEAST.getKey();
                break;
            }
            case 33: {
                key = ArmourVariant.VAMPIRE_OF_VENICE.getKey();
                break;
            }
            case 34: {
                key = ArmourVariant.VASHTA_NERADA.getKey();
                break;
            }
            case 35: {
                key = ArmourVariant.WEEPING_ANGEL.getKey();
                break;
            }
            case 36: {
                key = ArmourVariant.ZYGON.getKey();
                break;
            }
        }
        return key;
    }
}

