/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.monsters.empty_child;

import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.keys.EmptyChildVariant;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.EquippableComponent;
import org.bukkit.plugin.Plugin;

public class GasMask
implements Listener {
    private final TARDIS plugin;

    public GasMask(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (!TARDISWeepingAngels.getEmpty().contains(uuid)) {
            return;
        }
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            PlayerInventory inv = player.getInventory();
            ItemStack helmet = inv.getHelmet();
            if (helmet != null) {
                int free_slot = inv.firstEmpty();
                if (free_slot != -1) {
                    inv.setItem(free_slot, helmet);
                } else {
                    player.getWorld().dropItemNaturally(player.getLocation(), helmet);
                }
            }
            ItemStack gasmask = ItemStack.of((Material)Material.SUGAR, (int)1);
            ItemMeta im = gasmask.getItemMeta();
            im.displayName((Component)Component.text((String)"Gas Mask"));
            im.setItemModel(EmptyChildVariant.EMPTY_CHILD_MASK.getKey());
            EquippableComponent component = im.getEquippable();
            component.setCameraOverlay(EmptyChildVariant.EMPTY_CHILD_OVERLAY.getKey());
            im.setEquippable(component);
            gasmask.setItemMeta(im);
            inv.setHelmet(gasmask);
            player.updateInventory();
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                TARDISWeepingAngels.getEmpty().remove(uuid);
                TARDISWeepingAngels.getTimesUp().add(uuid);
            }, 600L);
        }, 5L);
    }

    @EventHandler
    public void onHelmetClick(InventoryClickEvent event) {
        if (event.getInventory().getType().equals((Object)InventoryType.CRAFTING) && event.getRawSlot() == 5) {
            Player player = (Player)event.getWhoClicked();
            if (TARDISWeepingAngels.getEmpty().contains(player.getUniqueId())) {
                event.setCancelled(true);
            }
            if (TARDISWeepingAngels.getTimesUp().contains(player.getUniqueId())) {
                event.setCancelled(true);
                player.getInventory().setHelmet(null);
                player.updateInventory();
                TARDISWeepingAngels.getTimesUp().remove(player.getUniqueId());
            }
        }
    }
}

