/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisvortexmanipulator.gui;

import java.util.HashMap;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.tardisvortexmanipulator.database.TVMResultSetSaves;
import me.eccentric_nz.tardisvortexmanipulator.storage.TVMSave;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TVMSavesGUI
implements InventoryHolder {
    private final TARDIS plugin;
    private final int start;
    private final int finish;
    private final String uuid;
    private final HashMap<String, Material> blocks = new HashMap();
    private final Inventory inventory;

    public TVMSavesGUI(TARDIS plugin, int start, int finish, String uuid) {
        this.plugin = plugin;
        this.start = start;
        this.finish = finish;
        this.uuid = uuid;
        this.blocks.put("NORMAL", Material.DIRT);
        this.blocks.put("NETHER", Material.NETHERRACK);
        this.blocks.put("THE_END", Material.END_STONE);
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, (Component)Component.text((String)"VM Saves", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getItemStack());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getItemStack() {
        ItemStack[] stack = new ItemStack[54];
        int i = 0;
        TVMResultSetSaves rs = new TVMResultSetSaves(this.plugin, this.uuid, this.start, 44);
        if (rs.resultSet()) {
            List<TVMSave> saves = rs.getSaves();
            for (TVMSave s : saves) {
                ItemStack save = ItemStack.of((Material)this.blocks.get(s.getEnv()), (int)1);
                ItemMeta warp = save.getItemMeta();
                warp.displayName((Component)Component.text((String)s.getName()));
                warp.lore(List.of(Component.text((String)("World: " + s.getWorld())), Component.text((String)("x: " + this.oneDecimal(s.getX()))), Component.text((String)("y: " + s.getY())), Component.text((String)("z: " + this.oneDecimal(s.getZ())))));
                save.setItemMeta(warp);
                stack[i] = save;
                ++i;
            }
        }
        int n = this.start / 44 + 1;
        ItemStack page = ItemStack.of((Material)Material.BOWL, (int)1);
        ItemMeta num = page.getItemMeta();
        num.displayName((Component)Component.text((String)("Page " + n)));
        page.setItemMeta(num);
        stack[45] = page;
        ItemStack close = ItemStack.of((Material)Material.BOWL, (int)1);
        ItemMeta win = close.getItemMeta();
        win.displayName((Component)Component.text((String)"Close"));
        close.setItemMeta(win);
        stack[46] = close;
        if (this.start > 0) {
            ItemStack prev = ItemStack.of((Material)Material.ARROW, (int)1);
            ItemMeta een = prev.getItemMeta();
            een.displayName((Component)Component.text((String)"Previous Page"));
            prev.setItemMeta(een);
            stack[48] = prev;
        }
        if (this.finish > 44) {
            ItemStack next = ItemStack.of((Material)Material.ARROW, (int)1);
            ItemMeta scr = next.getItemMeta();
            scr.displayName((Component)Component.text((String)"Next page"));
            next.setItemMeta(scr);
            stack[49] = next;
        }
        ItemStack del = ItemStack.of((Material)Material.BUCKET, (int)1);
        ItemMeta ete = del.getItemMeta();
        ete.displayName((Component)Component.text((String)"Delete"));
        del.setItemMeta(ete);
        stack[51] = del;
        ItemStack warp = ItemStack.of((Material)Material.BOWL, (int)1);
        ItemMeta to = warp.getItemMeta();
        to.displayName((Component)Component.text((String)"Enter Vortex"));
        warp.setItemMeta(to);
        stack[53] = warp;
        return stack;
    }

    private String oneDecimal(double d) {
        return String.format("%f.1", d);
    }
}

