/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischunkgenerator.worldgen.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemRegistry;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.rooms.TARDISPainting;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Art;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Rotation;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Display;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Painting;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class RoomsUtility {
    public static void fakeBlock(JsonObject json, LimitedRegion region, int sx, int sz) {
        JsonObject rel = json.get("rel_location").getAsJsonObject();
        int x = rel.get("x").getAsInt() + sx;
        int y = rel.get("y").getAsInt() + 64;
        int z = rel.get("z").getAsInt() + sz;
        NamespacedKey model = null;
        if (json.has("stack")) {
            JsonObject stack = json.get("stack").getAsJsonObject();
            if (stack.has("cmd")) {
                String key = stack.get("cmd").getAsString();
                model = new NamespacedKey((Plugin)TARDIS.plugin, key);
            }
            Material material = Material.valueOf((String)stack.get("type").getAsString());
            TARDISDisplayItem tdi = TARDISDisplayItemRegistry.getByModel(model);
            if (tdi != null) {
                RoomsUtility.set(region, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, tdi.getMaterial(), tdi.getCustomModel(), false);
            } else {
                RoomsUtility.set(region, (double)x + 0.5, (double)y + 0.25, (double)z + 0.5, material, model, true);
            }
        }
    }

    private static void set(LimitedRegion region, double x, double y, double z, Material material, NamespacedKey model, boolean inRoom) {
        Location location = new Location(null, x, y, z);
        ItemDisplay display = (ItemDisplay)region.spawnEntity(location, EntityType.ITEM_DISPLAY);
        ItemStack is = ItemStack.of((Material)material);
        if (model != null) {
            ItemMeta im = is.getItemMeta();
            im.setItemModel(model);
            is.setItemMeta(im);
        }
        display.setItemStack(is);
        if (inRoom) {
            display.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.GROUND);
            display.setBillboard(Display.Billboard.VERTICAL);
        }
        display.setInvulnerable(true);
    }

    public static void curate(JsonObject json, LimitedRegion region, int sx, int sz) {
        JsonObject rel = json.get("rel_location").getAsJsonObject();
        int x = rel.get("x").getAsInt() + sx;
        int y = rel.get("y").getAsInt() + 64;
        int z = rel.get("z").getAsInt() + sz;
        BlockFace facing = BlockFace.valueOf((String)json.get("facing").getAsString());
        Location l = new Location(null, (double)x, (double)y, (double)z);
        ItemFrame frame = (ItemFrame)region.spawnEntity(l, json.get("glowing").getAsBoolean() ? EntityType.GLOW_ITEM_FRAME : EntityType.ITEM_FRAME);
        frame.setFacingDirection(facing, true);
        if (json.has("item")) {
            try {
                ItemStack is = ItemStack.of((Material)Material.valueOf((String)json.get("item").getAsString()));
                ItemMeta im = is.getItemMeta();
                if (json.has("cmd")) {
                    String cmd = json.get("cmd").getAsString();
                    NamespacedKey key = new NamespacedKey((Plugin)TARDIS.plugin, cmd);
                    im.setItemModel(key);
                }
                if (json.has("name")) {
                    im.displayName((Component)Component.text((String)json.get("name").getAsString()));
                }
                if (json.has("lore")) {
                    ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
                    for (JsonElement element : json.get("lore").getAsJsonArray()) {
                        lore.add(Component.text((String)element.getAsString()));
                    }
                    im.lore(lore);
                }
                if (json.has("banner")) {
                    JsonObject banner = json.get("banner").getAsJsonObject();
                    DyeColor baseColour = DyeColor.valueOf((String)banner.get("base_colour").getAsString());
                    JsonArray patterns = banner.get("patterns").getAsJsonArray();
                    ArrayList<Pattern> plist = new ArrayList<Pattern>();
                    for (int j = 0; j < patterns.size(); ++j) {
                        JsonObject jo = patterns.get(j).getAsJsonObject();
                        PatternType pt = (PatternType)RegistryAccess.registryAccess().getRegistry(RegistryKey.BANNER_PATTERN).get(new NamespacedKey("minecraft", jo.get("pattern").getAsString().toLowerCase(Locale.ROOT)));
                        if (pt == null) continue;
                        DyeColor dc = DyeColor.valueOf((String)jo.get("pattern_colour").getAsString());
                        Pattern p = new Pattern(dc, pt);
                        plist.add(p);
                    }
                    BlockStateMeta bsm = (BlockStateMeta)im;
                    Banner b = (Banner)bsm.getBlockState();
                    b.setBaseColor(baseColour);
                    b.setPatterns(plist);
                    bsm.setBlockState((BlockState)b);
                }
                is.setItemMeta(im);
                frame.setItem(is, false);
            }
            catch (IllegalArgumentException e) {
                TARDIS.plugin.getMessenger().message((CommandSender)TARDIS.plugin.getConsole(), TardisModule.WARNING, "Could not create item stack for schematic item frame!");
            }
        }
        frame.setFixed(json.get("fixed").getAsBoolean());
        frame.setVisible(json.get("visible").getAsBoolean());
        Rotation rotation = Rotation.valueOf((String)json.get("rotation").getAsString());
        frame.setRotation(rotation);
    }

    public static void hang(JsonObject painting, LimitedRegion region, int sx, int sz) {
        JsonObject rel = painting.get("rel_location").getAsJsonObject();
        int px = rel.get("x").getAsInt() + sx;
        int py = rel.get("y").getAsInt() + 64;
        int pz = rel.get("z").getAsInt() + sz;
        BlockFace facing = BlockFace.valueOf((String)painting.get("facing").getAsString());
        Location pl = null;
        String which = painting.get("art").getAsString();
        String[] split = which.split(":");
        Art art = (Art)RegistryAccess.registryAccess().getRegistry(RegistryKey.PAINTING_VARIANT).get(new NamespacedKey(split[0], split[1]));
        if (art != null) {
            pl = TARDISPainting.calculatePosition(art, facing, new Location(null, (double)px, (double)py, (double)pz));
        }
        if (pl != null) {
            try {
                Painting ent = (Painting)region.spawnEntity(pl, EntityType.PAINTING);
                ent.setFacingDirection(facing, true);
                ent.setArt(art, true);
            }
            catch (IllegalArgumentException e) {
                TARDIS.plugin.debug("Invalid painting location!" + String.valueOf(pl));
            }
        }
    }

    public static void flag(JsonObject json, Banner banner) {
        ArrayList<Pattern> plist = new ArrayList<Pattern>();
        JsonArray patterns = json.get("patterns").getAsJsonArray();
        for (int j = 0; j < patterns.size(); ++j) {
            JsonObject jo = patterns.get(j).getAsJsonObject();
            PatternType pt = (PatternType)RegistryAccess.registryAccess().getRegistry(RegistryKey.BANNER_PATTERN).get(new NamespacedKey("minecraft", jo.get("pattern").getAsString().toLowerCase(Locale.ROOT)));
            if (pt == null) continue;
            DyeColor dc = DyeColor.valueOf((String)jo.get("pattern_colour").getAsString());
            Pattern p = new Pattern(dc, pt);
            plist.add(p);
        }
        banner.setPatterns(plist);
        banner.update();
    }
}

