/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.travel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.advanced.CircuitChecker;
import me.eccentric_nz.TARDIS.advanced.CircuitDamager;
import me.eccentric_nz.TARDIS.builders.utility.LightLevel;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemRegistry;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.customblocks.TARDISLightDisplayItem;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetArtronStorage;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetInteractionCheck;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetInteriorLightLevel;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetLamps;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.TardisLight;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.sensor.MalfunctionSensor;
import me.eccentric_nz.TARDIS.travel.TARDISEPSRunnable;
import me.eccentric_nz.TARDIS.travel.TARDISLampsRunnable;
import me.eccentric_nz.TARDIS.travel.TARDISMalfunctionExplosion;
import me.eccentric_nz.TARDIS.travel.TARDISTimeTravel;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TARDISMalfunction {
    private final TARDIS plugin;

    public TARDISMalfunction(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean isMalfunction() {
        boolean mal = false;
        if (this.plugin.getConfig().getInt("preferences.malfunction") > 0) {
            int chance = 100 - this.plugin.getConfig().getInt("preferences.malfunction");
            if (TARDISConstants.RANDOM.nextInt(100) > chance) {
                mal = true;
            }
        }
        return mal;
    }

    public Location getMalfunction(int id, Player p, COMPASS dir, Location handbrake_loc, String eps, String creeper) {
        Location l;
        ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
        if (rsc.resultSet()) {
            int end = 100 - this.plugin.getConfig().getInt("preferences.malfunction_end");
            int nether = end - this.plugin.getConfig().getInt("preferences.malfunction_nether");
            int r = TARDISConstants.RANDOM.nextInt(100);
            TARDISTimeTravel tt = new TARDISTimeTravel(this.plugin);
            int x = TARDISConstants.RANDOM.nextInt(4) + 1;
            int z = TARDISConstants.RANDOM.nextInt(4) + 1;
            int y = TARDISConstants.RANDOM.nextInt(4) + 1;
            Current current = rsc.getCurrent();
            l = r > end ? tt.randomDestination(p, x, z, y, dir, "THE_END", null, true, current.location()) : (r > nether ? tt.randomDestination(p, x, z, y, dir, "NETHER", null, true, current.location()) : tt.randomDestination(p, x, z, y, dir, "NORMAL", null, false, current.location()));
        } else {
            l = null;
        }
        if (l != null) {
            this.doMalfunction(id, p, eps, creeper, handbrake_loc);
        }
        return l;
    }

    private void doMalfunction(int id, Player p, String eps, String creeper, Location handbrake) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        ResultSetLamps rsl = new ResultSetLamps(this.plugin, where, true);
        if (rsl.resultSet()) {
            ResultSetPlayerPrefs rsp;
            ResultSetArtronStorage rsa;
            int malfunctionDamage = this.plugin.getConfig().getInt("circuits.malfunction_damage");
            if (this.plugin.getConfig().getBoolean("circuits.damage") && malfunctionDamage > 0 && !this.plugin.getConfig().getBoolean("difficulty.circuits")) {
                DiskCircuit circuit = DiskCircuit.getTardisCircuits().get(TARDISConstants.RANDOM.nextInt(DiskCircuit.getTardisCircuits().size()));
                CircuitChecker tcc = new CircuitChecker(this.plugin, id);
                tcc.getCircuits();
                double percent = (double)malfunctionDamage / 100.0;
                switch (circuit) {
                    case ARS: {
                        if (!tcc.hasARS()) break;
                        int damage = (int)(this.plugin.getConfig().getDouble("circuits.uses.ars") * percent);
                        int usesLeft = tcc.getArsUses() - damage;
                        this.damage(circuit, usesLeft, id, p);
                        break;
                    }
                    case CHAMELEON: {
                        if (!tcc.hasChameleon()) break;
                        int damage = (int)(this.plugin.getConfig().getDouble("circuits.uses.chameleon") * percent);
                        int usesLeft = tcc.getChameleonUses() - damage;
                        this.damage(circuit, usesLeft, id, p);
                        break;
                    }
                    case INPUT: {
                        if (!tcc.hasInput()) break;
                        int damage = (int)(this.plugin.getConfig().getDouble("circuits.uses.input") * percent);
                        int usesLeft = tcc.getInputUses() - damage;
                        this.damage(circuit, usesLeft, id, p);
                        break;
                    }
                    case INVISIBILITY: {
                        if (!tcc.hasInvisibility()) break;
                        int damage = (int)(this.plugin.getConfig().getDouble("circuits.uses.invisibility") * percent);
                        int usesLeft = tcc.getInvisibilityUses() - damage;
                        this.damage(circuit, usesLeft, id, p);
                        break;
                    }
                    case MATERIALISATION: {
                        if (!tcc.hasMaterialisation()) break;
                        int damage = (int)(this.plugin.getConfig().getDouble("circuits.uses.materialisation") * percent);
                        int usesLeft = tcc.getMaterialisationUses() - damage;
                        this.damage(circuit, usesLeft, id, p);
                        break;
                    }
                    case MEMORY: {
                        if (!tcc.hasMemory()) break;
                        int damage = (int)(this.plugin.getConfig().getDouble("circuits.uses.memory") * percent);
                        int usesLeft = tcc.getMemoryUses() - damage;
                        this.damage(circuit, usesLeft, id, p);
                        break;
                    }
                    case RANDOMISER: {
                        if (!tcc.hasRandomiser()) break;
                        int damage = (int)(this.plugin.getConfig().getDouble("circuits.uses.randomiser") * percent);
                        int usesLeft = tcc.getRandomiserUses() - damage;
                        this.damage(circuit, usesLeft, id, p);
                        break;
                    }
                    case SCANNER: {
                        if (!tcc.hasScanner()) break;
                        int damage = (int)(this.plugin.getConfig().getDouble("circuits.uses.scanner") * percent);
                        int usesLeft = tcc.getScannerUses() - damage;
                        this.damage(circuit, usesLeft, id, p);
                        break;
                    }
                    case TEMPORAL: {
                        if (!tcc.hasTemporal()) break;
                        int damage = (int)(this.plugin.getConfig().getDouble("circuits.uses.temporal") * percent);
                        int usesLeft = tcc.getTemporalUses() - damage;
                        this.damage(circuit, usesLeft, id, p);
                        break;
                    }
                }
            }
            if ((rsa = new ResultSetArtronStorage(this.plugin)).fromID(id)) {
                int c = rsa.getCapacitorCount();
                int d = rsa.getDamageCount();
                if (d < c && TARDISConstants.RANDOM.nextInt(100) < this.plugin.getArtronConfig().getInt("malfunction_damage")) {
                    HashMap<String, Object> setd = new HashMap<String, Object>();
                    setd.put("damaged", ++d);
                    HashMap<String, Object> whered = new HashMap<String, Object>();
                    setd.put("tardis_id", id);
                    this.plugin.getQueryFactory().doUpdate("eyes", setd, whered);
                    this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "CAPACITOR_DAMAGE");
                }
            }
            if ((rsp = new ResultSetPlayerPrefs(this.plugin, p.getUniqueId().toString())).resultSet()) {
                ResultSetInteriorLightLevel rs;
                if (this.plugin.getConfig().getBoolean("allow.emergency_npc") && rsp.isEpsOn()) {
                    List<UUID> playerUUIDs;
                    String message = "This is Emergency Programme One. Now listen, this is important. If this message is activated, then it can only mean one thing: we must be in danger, and I mean fatal. You're about to die any second with no chance of escape.";
                    HashMap<String, Object> wherev = new HashMap<String, Object>();
                    wherev.put("tardis_id", id);
                    ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wherev, true);
                    if (rst.resultSet()) {
                        playerUUIDs = rst.getData();
                    } else {
                        playerUUIDs = new ArrayList<UUID>();
                        playerUUIDs.add(p.getUniqueId());
                    }
                    TARDISEPSRunnable EPS_runnable = new TARDISEPSRunnable(this.plugin, message, p, playerUUIDs, id, eps, creeper);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)EPS_runnable, 220L);
                }
                TardisLight light = TardisLight.TENTH;
                TARDISDisplayItem tdi = TARDISLightDisplayItem.LIGHT_TENTH_ON;
                ItemDisplay display = TARDISDisplayItemUtils.get(rsl.getData().getFirst().block());
                if (display != null) {
                    tdi = TARDISDisplayItemRegistry.getByItemDisplay(display);
                    light = TardisLight.getFromDisplayItem(tdi);
                }
                int level = (rs = new ResultSetInteriorLightLevel(this.plugin, id)).resultSet() ? LightLevel.interior_level[rs.getLevel()] : 15;
                long end = System.currentTimeMillis() + 10000L;
                TARDISLampsRunnable runnable = new TARDISLampsRunnable(this.plugin, rsl.getData(), end, light, light.getOn() == tdi, level);
                runnable.setHandbrake(handbrake);
                int taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, 10L, 10L);
                runnable.setTask(taskID);
                ResultSetInteractionCheck rsic = new ResultSetInteractionCheck(this.plugin);
                TARDISMalfunctionExplosion explodeable = new TARDISMalfunctionExplosion(this.plugin, id, end, rsic.resultSetFromId(id));
                int taskEx = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)explodeable, 10L, 30L);
                explodeable.setTask(taskEx);
            }
            new MalfunctionSensor(this.plugin, id).toggle();
        }
    }

    private void damage(DiskCircuit circuit, int uses_left, int id, Player p) {
        CircuitDamager tcd = new CircuitDamager(this.plugin, circuit, uses_left, id, p);
        tcd.damage();
    }
}

