/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.sonic;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.sonic.SonicItemComparator;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.protection.TARDISLWCChecker;
import me.eccentric_nz.TARDIS.utility.protection.TARDISTownyChecker;
import nl.rutgerkok.blocklocker.BlockLockerAPIv2;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class SonicSorterListener
implements Listener {
    private final TARDIS plugin;
    private final Set<Material> sortables = new HashSet<Material>();

    public SonicSorterListener(TARDIS plugin) {
        this.plugin = plugin;
        this.sortables.add(Material.BARREL);
        this.sortables.add(Material.CHEST);
        this.sortables.add(Material.TRAPPED_CHEST);
        this.sortables.addAll(Tag.SHULKER_BOXES.getValues());
    }

    private static ItemStack[] sortInventory(ItemStack[] items) {
        int endIndex = items.length;
        block0: for (int i = 0; i < endIndex; ++i) {
            ItemStack item1 = items[i];
            if (item1 == null) continue;
            int maxStackSize = item1.getMaxStackSize();
            if (item1.getAmount() <= 0 || maxStackSize == 1 || item1.getAmount() >= maxStackSize) continue;
            int needed = maxStackSize - item1.getAmount();
            for (int j = i + 1; j < endIndex; ++j) {
                ItemStack item2 = items[j];
                if (item2 == null || item2.getAmount() <= 0 || item2.getType() != item1.getType()) continue;
                ItemMeta itemMeta = item1.getItemMeta();
                if (itemMeta instanceof Damageable) {
                    Damageable d1 = (Damageable)itemMeta;
                    Damageable d2 = (Damageable)item2.getItemMeta();
                    if (d1.getDamage() != d2.getDamage() || !item1.getEnchantments().equals(item2.getEnchantments()) || !item1.getItemMeta().equals((Object)item2.getItemMeta())) continue;
                    if (item2.getAmount() > needed) {
                        item1.setAmount(maxStackSize);
                        item2.setAmount(item2.getAmount() - needed);
                        continue block0;
                    }
                    items[j] = null;
                    item1.setAmount(item1.getAmount() + item2.getAmount());
                    needed = maxStackSize - item1.getAmount();
                    continue;
                }
                if (!item1.getEnchantments().equals(item2.getEnchantments()) || !item1.getItemMeta().equals((Object)item2.getItemMeta())) continue;
                if (item2.getAmount() > needed) {
                    item1.setAmount(maxStackSize);
                    item2.setAmount(item2.getAmount() - needed);
                    continue block0;
                }
                items[j] = null;
                item1.setAmount(item1.getAmount() + item2.getAmount());
                needed = maxStackSize - item1.getAmount();
            }
        }
        Arrays.sort(items, 0, endIndex, new SonicItemComparator());
        return items;
    }

    public static void sortInventory(Inventory inventory) {
        inventory.setContents(SonicSorterListener.sortInventory(inventory.getContents()));
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        Block block;
        ItemMeta im;
        ItemStack is;
        if (event.getHand() == null || event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        Player player = event.getPlayer();
        if (event.getAction() == Action.LEFT_CLICK_BLOCK && TARDISPermission.hasPermission(player, "tardis.sonic.sort") && (is = player.getInventory().getItemInMainHand()).hasItemMeta() && (im = is.getItemMeta()).hasDisplayName() && ComponentUtils.endsWith(im.displayName(), "Sonic Screwdriver") && (block = event.getClickedBlock()) != null && this.sortables.contains(block.getType())) {
            boolean allow = true;
            if (this.plugin.getPM().isPluginEnabled("BlockLocker") && BlockLockerAPIv2.isProtected((Block)block)) {
                allow = false;
            }
            if (this.plugin.getPM().isPluginEnabled("Towny")) {
                allow = new TARDISTownyChecker(this.plugin).checkTowny(player, block.getLocation());
            }
            if (this.plugin.getPM().isPluginEnabled("LWC")) {
                boolean bl = allow = !new TARDISLWCChecker().isBlockProtected(block, player);
            }
            if (allow) {
                Inventory inventory = ((InventoryHolder)block.getState()).getInventory();
                SonicSorterListener.sortInventory(inventory);
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CHEST_SORTED");
            }
        }
    }
}

