/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.sonic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.data.ConfiguredSonic;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetConfiguredSonic;
import me.eccentric_nz.TARDIS.enumeration.SonicConfig;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.sonic.SonicConfiguratorInventory;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class SonicConfiguratorMenuListener
extends TARDISMenuListener {
    private final TARDIS plugin;
    private final HashMap<UUID, ConfiguredSonic> sonics = new HashMap();

    public SonicConfiguratorMenuListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onSonicConfiguratorMenuClick(InventoryClickEvent event) {
        InventoryView view = event.getView();
        if (!(event.getInventory().getHolder(false) instanceof SonicConfiguratorInventory)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 53) {
            ClickType click = event.getClick();
            if (click.equals((Object)ClickType.SHIFT_RIGHT) || click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.DOUBLE_CLICK)) {
                this.plugin.debug("TARDISSonicConfiguratorMenuListener");
                event.setCancelled(true);
            }
            return;
        }
        event.setCancelled(slot != 45);
        switch (slot) {
            case 45: {
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                    this.loadSonic(view.getItem(45), player, view);
                    this.setOptions(player, view);
                }, 1L);
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 27: {
                this.toggleOption(view, slot);
                break;
            }
            case 52: {
                this.saveConfiguredSonic(player, view);
                break;
            }
            case 53: {
                this.close(player);
                break;
            }
            default: {
                event.setCancelled(true);
            }
        }
    }

    private void loadSonic(ItemStack sonic, Player player, InventoryView view) {
        if (!TARDISStaticUtils.isSonic(sonic)) {
            return;
        }
        ItemMeta im = sonic.getItemMeta();
        ConfiguredSonic configuredSonic = im.getPersistentDataContainer().has(this.plugin.getSonicUuidKey(), this.plugin.getPersistentDataTypeUUID()) ? this.getConfiguredSonic((UUID)im.getPersistentDataContainer().get(this.plugin.getSonicUuidKey(), this.plugin.getPersistentDataTypeUUID()), im) : this.createConfiguredSonic(player, view);
        if (configuredSonic != null) {
            this.sonics.put(player.getUniqueId(), configuredSonic);
        }
    }

    private void setOptions(Player player, InventoryView view) {
        ConfiguredSonic configuredSonic = this.sonics.get(player.getUniqueId());
        if (configuredSonic == null) {
            return;
        }
        ItemStack bio = view.getItem(9);
        ItemMeta bim = bio.getItemMeta();
        bim.displayName((Component)Component.text((String)configuredSonic.getBio().getName()));
        ItemStack biosub = ItemStack.of((Material)configuredSonic.getBio().getMaterial());
        biosub.setItemMeta(bim);
        view.setItem(9, biosub);
        ItemStack dia = view.getItem(10);
        ItemMeta dim = dia.getItemMeta();
        dim.displayName((Component)Component.text((String)configuredSonic.getDiamond().getName()));
        ItemStack diasub = ItemStack.of((Material)configuredSonic.getDiamond().getMaterial());
        diasub.setItemMeta(dim);
        view.setItem(10, diasub);
        ItemStack eme = view.getItem(11);
        ItemMeta eim = eme.getItemMeta();
        eim.displayName((Component)Component.text((String)configuredSonic.getEmerald().getName()));
        ItemStack emesub = ItemStack.of((Material)configuredSonic.getEmerald().getMaterial());
        emesub.setItemMeta(eim);
        view.setItem(11, emesub);
        ItemStack red = view.getItem(12);
        ItemMeta rim = red.getItemMeta();
        rim.displayName((Component)Component.text((String)configuredSonic.getRedstone().getName()));
        ItemStack redsub = ItemStack.of((Material)configuredSonic.getRedstone().getMaterial());
        redsub.setItemMeta(rim);
        view.setItem(12, redsub);
        ItemStack pai = view.getItem(13);
        ItemMeta pim = pai.getItemMeta();
        pim.displayName((Component)Component.text((String)configuredSonic.getPainter().getName()));
        ItemStack paisub = ItemStack.of((Material)configuredSonic.getPainter().getMaterial());
        paisub.setItemMeta(pim);
        view.setItem(13, paisub);
        ItemStack ign = view.getItem(14);
        ItemMeta iim = ign.getItemMeta();
        iim.displayName((Component)Component.text((String)configuredSonic.getIgnite().getName()));
        ItemStack ignsub = ItemStack.of((Material)configuredSonic.getIgnite().getMaterial());
        ignsub.setItemMeta(iim);
        view.setItem(14, ignsub);
        ItemStack arr = view.getItem(15);
        ItemMeta aim = arr.getItemMeta();
        aim.displayName((Component)Component.text((String)configuredSonic.getArrow().getName()));
        ItemStack arrsub = ItemStack.of((Material)configuredSonic.getArrow().getMaterial());
        arrsub.setItemMeta(aim);
        view.setItem(15, arrsub);
        ItemStack kno = view.getItem(16);
        ItemMeta kim = kno.getItemMeta();
        kim.displayName((Component)Component.text((String)configuredSonic.getKnockback().getName()));
        ItemStack knosub = ItemStack.of((Material)configuredSonic.getKnockback().getMaterial());
        knosub.setItemMeta(kim);
        view.setItem(16, knosub);
        ItemStack bru = view.getItem(17);
        ItemMeta sh = bru.getItemMeta();
        sh.displayName((Component)Component.text((String)configuredSonic.getBrush().getName()));
        ItemStack brusub = ItemStack.of((Material)configuredSonic.getBrush().getMaterial());
        brusub.setItemMeta(sh);
        view.setItem(17, brusub);
        ItemStack con = view.getItem(27);
        ItemMeta ver = con.getItemMeta();
        ver.displayName((Component)Component.text((String)configuredSonic.getConversion().getName()));
        ItemStack consub = ItemStack.of((Material)configuredSonic.getConversion().getMaterial());
        consub.setItemMeta(ver);
        view.setItem(27, consub);
    }

    private void toggleOption(InventoryView view, int slot) {
        ItemStack option = view.getItem(slot);
        ItemMeta im = option.getItemMeta();
        Material cmd = option.getType();
        Material m = Material.LIME_WOOL;
        switch (cmd) {
            case LIME_WOOL: {
                im.displayName((Component)Component.text((String)"Disabled"));
                m = Material.RED_WOOL;
                break;
            }
            case RED_WOOL: {
                im.displayName((Component)Component.text((String)"Enabled"));
                break;
            }
            default: {
                m = Material.RED_WOOL;
            }
        }
        ItemStack sub = ItemStack.of((Material)m);
        sub.setItemMeta(im);
        view.setItem(slot, sub);
    }

    private ConfiguredSonic getConfiguredSonic(UUID sonic_uuid, ItemMeta im) {
        ResultSetConfiguredSonic rscs = new ResultSetConfiguredSonic(this.plugin, sonic_uuid);
        if (rscs.resultSet()) {
            ConfiguredSonic configuredSonic = rscs.getConfiguredSonic();
            List lore = im.lore();
            if (lore != null) {
                block24: for (int i = 1; i < lore.size(); ++i) {
                    String upgrade;
                    switch (upgrade = ComponentUtils.stripColour((Component)lore.get(i))) {
                        case "Bio-scanner Upgrade": {
                            configuredSonic.setBio(SonicConfig.ENABLED);
                            continue block24;
                        }
                        case "Diamond Upgrade": {
                            configuredSonic.setDiamond(SonicConfig.ENABLED);
                            continue block24;
                        }
                        case "Emerald Upgrade": {
                            configuredSonic.setEmerald(SonicConfig.ENABLED);
                            continue block24;
                        }
                        case "Redstone Upgrade": {
                            configuredSonic.setRedstone(SonicConfig.ENABLED);
                            continue block24;
                        }
                        case "Painter Upgrade": {
                            configuredSonic.setPainter(SonicConfig.ENABLED);
                            continue block24;
                        }
                        case "Ignite Upgrade": {
                            configuredSonic.setIgnite(SonicConfig.ENABLED);
                            continue block24;
                        }
                        case "Pickup Arrows Upgrade": {
                            configuredSonic.setArrow(SonicConfig.ENABLED);
                            continue block24;
                        }
                        case "Knockback Upgrade": {
                            configuredSonic.setKnockback(SonicConfig.ENABLED);
                            continue block24;
                        }
                        case "Brush Upgrade": {
                            configuredSonic.setBrush(SonicConfig.ENABLED);
                            continue block24;
                        }
                        case "Conversion Upgrade": {
                            configuredSonic.setConversion(SonicConfig.ENABLED);
                            continue block24;
                        }
                    }
                }
            }
            return configuredSonic;
        }
        return null;
    }

    private void saveConfiguredSonic(Player player, InventoryView view) {
        ArrayList<TextComponent> upgrades = new ArrayList<TextComponent>();
        upgrades.add(Component.text((String)"Upgrades:"));
        ConfiguredSonic configuredSonic = this.sonics.get(player.getUniqueId());
        if (configuredSonic == null) {
            return;
        }
        int bio = this.getSonicConfig(9, view);
        if (bio == 1) {
            upgrades.add(Component.text((String)"Bio-scanner Upgrade"));
        }
        configuredSonic.setBio(SonicConfig.values()[bio]);
        int dia = this.getSonicConfig(10, view);
        if (dia == 1) {
            upgrades.add(Component.text((String)"Diamond Upgrade"));
        }
        configuredSonic.setDiamond(SonicConfig.values()[dia]);
        int eme = this.getSonicConfig(11, view);
        if (eme == 1) {
            upgrades.add(Component.text((String)"Emerald Upgrade"));
        }
        configuredSonic.setEmerald(SonicConfig.values()[eme]);
        int red = this.getSonicConfig(12, view);
        if (red == 1) {
            upgrades.add(Component.text((String)"Redstone Upgrade"));
        }
        configuredSonic.setRedstone(SonicConfig.values()[red]);
        int pai = this.getSonicConfig(13, view);
        if (pai == 1) {
            upgrades.add(Component.text((String)"Painter Upgrade"));
        }
        configuredSonic.setPainter(SonicConfig.values()[pai]);
        int ign = this.getSonicConfig(14, view);
        if (ign == 1) {
            upgrades.add(Component.text((String)"Ignite Upgrade"));
        }
        configuredSonic.setIgnite(SonicConfig.values()[ign]);
        int arr = this.getSonicConfig(15, view);
        if (arr == 1) {
            upgrades.add(Component.text((String)"Pickup Arrows Upgrade"));
        }
        configuredSonic.setArrow(SonicConfig.values()[arr]);
        int kno = this.getSonicConfig(16, view);
        if (kno == 1) {
            upgrades.add(Component.text((String)"Knockback Upgrade"));
        }
        configuredSonic.setKnockback(SonicConfig.values()[kno]);
        int bru = this.getSonicConfig(17, view);
        if (bru == 1) {
            upgrades.add(Component.text((String)"Brush Upgrade"));
        }
        configuredSonic.setBrush(SonicConfig.values()[bru]);
        int con = this.getSonicConfig(27, view);
        if (con == 1) {
            upgrades.add(Component.text((String)"Conversion Upgrade"));
        }
        configuredSonic.setBrush(SonicConfig.values()[bru]);
        this.sonics.put(player.getUniqueId(), configuredSonic);
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("bio", bio);
        set.put("diamond", dia);
        set.put("emerald", eme);
        set.put("redstone", red);
        set.put("painter", pai);
        set.put("ignite", ign);
        set.put("arrow", arr);
        set.put("knockback", kno);
        set.put("brush", bru);
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("sonic_id", configuredSonic.getSonic_id());
        this.plugin.getQueryFactory().doUpdate("sonic", set, where);
        ItemStack sonic = view.getItem(45);
        if (TARDISStaticUtils.isSonic(sonic)) {
            ItemMeta im = sonic.getItemMeta();
            if (upgrades.size() > 1) {
                im.lore(upgrades);
            } else {
                im.lore(null);
            }
            sonic.setItemMeta(im);
        }
    }

    private int getSonicConfig(int slot, InventoryView view) {
        ItemStack option = view.getItem(slot);
        return switch (option.getType()) {
            case Material.LIME_WOOL -> 1;
            case Material.RED_WOOL -> 2;
            default -> 0;
        };
    }

    private ConfiguredSonic createConfiguredSonic(Player player, InventoryView view) {
        ItemStack is = view.getItem(45);
        if (TARDISStaticUtils.isSonic(is)) {
            ItemMeta im = is.getItemMeta();
            List lore = im.lore();
            UUID uuid = player.getUniqueId();
            int bio = lore != null && lore.contains(Component.text((String)"Bio-scanner Upgrade")) ? 1 : 0;
            int diamond = lore != null && lore.contains(Component.text((String)"Diamond Upgrade")) ? 1 : 0;
            int emerald = lore != null && lore.contains(Component.text((String)"Emerald Upgrade")) ? 1 : 0;
            int redstone = lore != null && lore.contains(Component.text((String)"Redstone Upgrade")) ? 1 : 0;
            int painter = lore != null && lore.contains(Component.text((String)"Painter Upgrade")) ? 1 : 0;
            int ignite = lore != null && lore.contains(Component.text((String)"Ignite Upgrade")) ? 1 : 0;
            int arrow = lore != null && lore.contains(Component.text((String)"Pickup Arrows Upgrade")) ? 1 : 0;
            int knockback = lore != null && lore.contains(Component.text((String)"Knockback Upgrade")) ? 1 : 0;
            int brush = lore != null && lore.contains(Component.text((String)"Brush Upgrade")) ? 1 : 0;
            int conversion = lore != null && lore.contains(Component.text((String)"Conversion Upgrade")) ? 1 : 0;
            UUID sonic_uuid = UUID.randomUUID();
            im.getPersistentDataContainer().set(this.plugin.getSonicUuidKey(), this.plugin.getPersistentDataTypeUUID(), (Object)sonic_uuid);
            is.setItemMeta(im);
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("uuid", uuid.toString());
            set.put("bio", bio);
            set.put("diamond", diamond);
            set.put("emerald", emerald);
            set.put("redstone", redstone);
            set.put("painter", painter);
            set.put("ignite", ignite);
            set.put("arrow", arrow);
            set.put("knockback", knockback);
            set.put("brush", brush);
            set.put("conversion", conversion);
            set.put("sonic_uuid", sonic_uuid.toString());
            int id = this.plugin.getQueryFactory().doSyncInsert("sonic", set);
            return new ConfiguredSonic(id, uuid, bio, diamond, emerald, redstone, painter, ignite, arrow, knockback, brush, conversion, sonic_uuid);
        }
        return null;
    }

    @EventHandler(ignoreCancelled=true)
    public void onSonicConfiguratorMenuClose(InventoryCloseEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof SonicConfiguratorInventory)) {
            return;
        }
        InventoryView view = event.getView();
        ItemStack sonic = view.getItem(45);
        if (sonic != null) {
            Player p = (Player)event.getPlayer();
            Location loc = p.getLocation();
            loc.getWorld().dropItemNaturally(loc, sonic);
            view.setItem(45, ItemStack.of((Material)Material.AIR));
        }
    }
}

