/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.schematic.setters;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.rotors.TimeRotor;
import me.eccentric_nz.TARDIS.schematic.setters.ItemStackSetter;
import org.bukkit.Location;
import org.bukkit.Rotation;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.BoundingBox;

public class ItemFrameSetter {
    public static void curate(JsonArray frames, Location start, int id) {
        for (int i = 0; i < frames.size(); ++i) {
            JsonObject json = frames.get(i).getAsJsonObject();
            JsonObject rel = json.get("rel_location").getAsJsonObject();
            int px = rel.get("x").getAsInt();
            int py = rel.get("y").getAsInt();
            int pz = rel.get("z").getAsInt();
            BlockFace facing = BlockFace.valueOf((String)json.get("facing").getAsString());
            Location l = new Location(start.getWorld(), (double)(start.getBlockX() + px), (double)(start.getBlockY() + py), (double)(start.getBlockZ() + pz));
            ItemFrame frame = (ItemFrame)start.getWorld().spawnEntity(l, json.get("glowing").getAsBoolean() ? EntityType.GLOW_ITEM_FRAME : EntityType.ITEM_FRAME);
            frame.setFacingDirection(facing, true);
            String cmd = "";
            if (json.has("item")) {
                ItemStack is = ItemStackSetter.build(json.get("item") instanceof JsonPrimitive ? json : json.get("item").getAsJsonObject());
                frame.setItem(is, false);
                if (json.has("rotation")) {
                    Rotation rotation = Rotation.valueOf((String)json.get("rotation").getAsString());
                    frame.setRotation(rotation);
                }
            }
            if (json.has("rotor") && id != -1) {
                frame.getPersistentDataContainer().set(TARDIS.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)cmd);
                TimeRotor.updateRotorRecord(id, frame.getUniqueId().toString());
            }
            if (json.has("microscope")) {
                frame.getPersistentDataContainer().set(TARDIS.plugin.getMicroscopeKey(), PersistentDataType.INTEGER, (Object)10000);
            }
            frame.setFixed(json.get("fixed").getAsBoolean());
            frame.setVisible(json.get("visible").getAsBoolean());
            Rotation rotation = Rotation.valueOf((String)json.get("rotation").getAsString());
            frame.setRotation(rotation);
        }
    }

    public static ItemFrame getItemFrameFromLocation(Location location) {
        BoundingBox box = new BoundingBox((double)location.getBlockX(), (double)location.getBlockY(), (double)location.getBlockZ(), (double)(location.getBlockX() + 1), (double)(location.getBlockY() + 1), (double)(location.getBlockZ() + 1));
        for (Entity e2 : location.getWorld().getNearbyEntities(box, e -> e.getType() == EntityType.ITEM_FRAME)) {
            if (!(e2 instanceof ItemFrame)) continue;
            ItemFrame frame = (ItemFrame)e2;
            return frame;
        }
        return null;
    }
}

