/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms.games.connect_four;

import java.util.ArrayList;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.rooms.games.GameOutcome;
import me.eccentric_nz.TARDIS.rooms.games.connect_four.ConnectFourInventory;
import me.eccentric_nz.TARDIS.rooms.games.connect_four.Grid;
import me.eccentric_nz.TARDIS.rooms.games.connect_four.Robot;
import me.eccentric_nz.TARDIS.rooms.games.rockpaperscissors.Letters;
import me.eccentric_nz.TARDIS.rooms.games.tictactoe.MatchState;
import net.kyori.adventure.text.Component;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ConnectFourListener
extends TARDISMenuListener {
    private final TARDIS plugin;
    private final List<List<Integer>> COLUMNS = new ArrayList<List<Integer>>();
    private final ItemStack hole;
    private final ItemStack red;
    private final ItemStack yellow;
    private final Robot tardis;
    private Grid grid;
    private MatchState state;

    public ConnectFourListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
        this.COLUMNS.add(List.of(Integer.valueOf(0), Integer.valueOf(9), Integer.valueOf(18), Integer.valueOf(27), Integer.valueOf(36), Integer.valueOf(45)));
        this.COLUMNS.add(List.of(Integer.valueOf(1), Integer.valueOf(10), Integer.valueOf(19), Integer.valueOf(28), Integer.valueOf(37), Integer.valueOf(46)));
        this.COLUMNS.add(List.of(Integer.valueOf(2), Integer.valueOf(11), Integer.valueOf(20), Integer.valueOf(29), Integer.valueOf(38), Integer.valueOf(47)));
        this.COLUMNS.add(List.of(Integer.valueOf(3), Integer.valueOf(12), Integer.valueOf(21), Integer.valueOf(30), Integer.valueOf(39), Integer.valueOf(48)));
        this.COLUMNS.add(List.of(Integer.valueOf(4), Integer.valueOf(13), Integer.valueOf(22), Integer.valueOf(31), Integer.valueOf(40), Integer.valueOf(49)));
        this.COLUMNS.add(List.of(Integer.valueOf(5), Integer.valueOf(14), Integer.valueOf(23), Integer.valueOf(32), Integer.valueOf(41), Integer.valueOf(50)));
        this.COLUMNS.add(List.of(Integer.valueOf(6), Integer.valueOf(15), Integer.valueOf(24), Integer.valueOf(33), Integer.valueOf(42), Integer.valueOf(51)));
        this.hole = ItemStack.of((Material)Material.BLUE_CONCRETE_POWDER);
        ItemMeta holeMeta = this.hole.getItemMeta();
        holeMeta.displayName((Component)Component.text((String)" "));
        this.hole.setItemMeta(holeMeta);
        this.red = ItemStack.of((Material)Material.RED_CONCRETE_POWDER);
        ItemMeta redMeta = this.red.getItemMeta();
        redMeta.displayName((Component)Component.text((String)"Red"));
        this.red.setItemMeta(redMeta);
        this.yellow = ItemStack.of((Material)Material.YELLOW_CONCRETE_POWDER);
        ItemMeta yellowMeta = this.yellow.getItemMeta();
        yellowMeta.displayName((Component)Component.text((String)"Yellow"));
        this.yellow.setItemMeta(yellowMeta);
        this.state = MatchState.PLAYER_TURN;
        this.grid = new Grid();
        this.tardis = new Robot(this.grid);
    }

    @EventHandler
    public void onConnectFourClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof ConnectFourInventory)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 54) {
            return;
        }
        final InventoryView view = event.getView();
        if (view.getItem(slot) == null) {
            return;
        }
        final Player player = (Player)event.getWhoClicked();
        switch (slot) {
            case 44: {
                view.getTopInventory().setContents(new ConnectFourInventory(this.plugin).getInventory().getContents());
                this.grid = new Grid();
                this.state = MatchState.PLAYER_TURN;
                break;
            }
            case 53: {
                this.close(player);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (this.state != MatchState.PLAYER_TURN || view.getItem(slot).getType() != Material.BLUE_CONCRETE_POWDER) {
                    return;
                }
                this.state = MatchState.TARDIS_TURN;
                final List<Integer> column = this.COLUMNS.get(slot);
                new BukkitRunnable(){
                    int start = 0;

                    public void run() {
                        if (this.start < 5 && view.getItem(((Integer)column.get(this.start + 1)).intValue()).getType() == Material.BLUE_CONCRETE_POWDER) {
                            view.setItem(((Integer)column.get(this.start)).intValue(), ConnectFourListener.this.hole);
                            view.setItem(((Integer)column.get(this.start + 1)).intValue(), ConnectFourListener.this.red);
                            ++this.start;
                        } else {
                            view.setItem(((Integer)column.get(this.start)).intValue(), ConnectFourListener.this.red);
                            int[] coords = ConnectFourListener.this.getRowCol((Integer)column.get(this.start));
                            ConnectFourListener.this.grid.setToken(coords[0], coords[1], Material.RED_CONCRETE_POWDER);
                            this.cancel();
                            if (ConnectFourListener.this.isGameOver()) {
                                ConnectFourListener.this.state = MatchState.PLAYER_WON;
                                ConnectFourListener.this.endGame(view, player);
                            } else if (ConnectFourListener.this.isDraw()) {
                                ConnectFourListener.this.state = MatchState.DRAW;
                                ConnectFourListener.this.endGame(view, player);
                            } else {
                                int c = ConnectFourListener.this.tardis.chooseColumn();
                                final List<Integer> column2 = ConnectFourListener.this.COLUMNS.get(c);
                                new BukkitRunnable(){
                                    int start = 0;

                                    public void run() {
                                        if (this.start < 5 && view.getItem(((Integer)column2.get(this.start + 1)).intValue()).getType() == Material.BLUE_CONCRETE_POWDER) {
                                            view.setItem(((Integer)column2.get(this.start)).intValue(), ConnectFourListener.this.hole);
                                            view.setItem(((Integer)column2.get(this.start + 1)).intValue(), ConnectFourListener.this.yellow);
                                            ++this.start;
                                        } else {
                                            view.setItem(((Integer)column2.get(this.start)).intValue(), ConnectFourListener.this.yellow);
                                            int[] coords = ConnectFourListener.this.getRowCol((Integer)column2.get(this.start));
                                            ConnectFourListener.this.grid.setToken(coords[0], coords[1], Material.YELLOW_CONCRETE_POWDER);
                                            this.cancel();
                                            if (ConnectFourListener.this.isGameOver()) {
                                                ConnectFourListener.this.state = MatchState.TARDIS_WON;
                                                ConnectFourListener.this.endGame(view, player);
                                            } else if (ConnectFourListener.this.isDraw()) {
                                                ConnectFourListener.this.state = MatchState.DRAW;
                                                ConnectFourListener.this.endGame(view, player);
                                            } else {
                                                ConnectFourListener.this.state = MatchState.PLAYER_TURN;
                                            }
                                        }
                                    }
                                }.runTaskTimer((Plugin)ConnectFourListener.this.plugin, 2L, 5L);
                            }
                        }
                    }
                }.runTaskTimer((Plugin)this.plugin, 2L, 5L);
                break;
            }
        }
    }

    private void endGame(InventoryView view, Player player) {
        GameOutcome result = null;
        ItemStack banner = null;
        String display = "";
        switch (this.state) {
            case DRAW: {
                result = GameOutcome.DRAW;
                banner = Letters.D(DyeColor.CYAN, DyeColor.WHITE);
                display = "It was a draw :|";
                break;
            }
            case PLAYER_WON: {
                result = GameOutcome.WIN;
                banner = Letters.W(DyeColor.LIME, DyeColor.WHITE);
                display = "You won :)";
                break;
            }
            case TARDIS_WON: {
                result = GameOutcome.LOSE;
                banner = Letters.L(DyeColor.MAGENTA, DyeColor.WHITE);
                display = "You lost :(";
                break;
            }
        }
        if (result != null) {
            ItemMeta im = banner.getItemMeta();
            im.displayName((Component)Component.text((String)display));
            banner.setItemMeta(im);
            player.playSound(player.getLocation(), result.getSound(), 0.8f, 0.8f);
            view.setItem(26, banner);
        }
    }

    private int[] getRowCol(int slot) {
        int row = 0;
        int col = 0;
        if (slot < 7) {
            col = slot;
        } else if (slot < 16) {
            col = slot - 9;
            row = 1;
        } else if (slot < 25) {
            col = slot - 18;
            row = 2;
        } else if (slot < 34) {
            col = slot - 27;
            row = 3;
        } else if (slot < 43) {
            col = slot - 36;
            row = 4;
        } else if (slot < 52) {
            col = slot - 45;
            row = 5;
        }
        return new int[]{row, col};
    }

    public boolean isGameOver() {
        return this.grid.checkHorizontally() || this.grid.checkVertically() || this.grid.checkDiagonally();
    }

    public boolean isDraw() {
        return this.grid.areAllColumnsFull() && !this.isGameOver();
    }
}

