/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.maze;

import me.eccentric_nz.TARDIS.TARDISConstants;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;

public final class MazeBuilder {
    private final boolean[][] maze;
    private final BlockData log = Material.DARK_OAK_LOG.createBlockData();
    private final BlockData leaves = Material.DARK_OAK_LEAVES.createBlockData();
    private final int size;
    private final Location location;

    public MazeBuilder(boolean[][] maze, Location location) {
        this.maze = maze;
        this.location = location;
        this.size = this.maze.length;
    }

    public void build(boolean reconfigure) {
        Block block;
        int d;
        int w;
        World world = this.location.getWorld();
        int x = this.location.getBlockX();
        int y = this.location.getBlockY();
        int z = this.location.getBlockZ();
        for (int h = 0; h < 4; ++h) {
            for (w = 0; w < this.size; ++w) {
                for (d = 0; d < this.size; ++d) {
                    block = world.getBlockAt(x + w, y + h, z + d);
                    if (this.maze[w][d]) {
                        block.setBlockData(h < 2 ? this.log : this.leaves);
                        continue;
                    }
                    block.setBlockData(TARDISConstants.AIR);
                }
            }
        }
        for (int r = 0; r < 2; ++r) {
            world.getBlockAt(x + 10, y + r, z + 5).setBlockData(TARDISConstants.AIR);
            world.getBlockAt(x + 5, y + r, z).setBlockData(TARDISConstants.AIR);
            world.getBlockAt(x, y + r, z + 5).setBlockData(TARDISConstants.AIR);
            world.getBlockAt(x + 5, y + r, z + 10).setBlockData(TARDISConstants.AIR);
        }
        if (reconfigure) {
            BlockData grass = Material.GRASS_BLOCK.createBlockData();
            for (w = 0; w < this.size; ++w) {
                for (d = 0; d < this.size; ++d) {
                    block = world.getBlockAt(x + w, y - 1, z + d);
                    block.setBlockData(grass);
                }
            }
        }
    }
}

