/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.SerializeInventory;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDiskStorage;
import me.eccentric_nz.TARDIS.enumeration.Storage;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TARDISBiomeReaderListener
implements Listener {
    private final TARDIS plugin;

    public TARDISBiomeReaderListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    public static boolean hasBiomeDisk(ItemStack[] stack, String biome) {
        boolean found = false;
        for (int s = 27; s < stack.length; ++s) {
            List lore;
            ItemMeta diskim;
            ItemStack disk = stack[s];
            if (disk == null || !disk.hasItemMeta() || !(diskim = disk.getItemMeta()).hasLore() || (lore = diskim.lore()) == null || !lore.contains(Component.text((String)biome.toUpperCase(Locale.ROOT)))) continue;
            found = true;
            break;
        }
        return found;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onInteract(PlayerInteractEvent event) {
        ItemMeta im;
        if (event.getHand() == null || event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
            return;
        }
        if (event.getClickedBlock().getType().isInteractable()) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack is = player.getInventory().getItemInMainHand();
        if (is.getType().equals((Object)Material.BRICK) && is.hasItemMeta() && (im = is.getItemMeta()).hasDisplayName() && ComponentUtils.endsWith(im.displayName(), "TARDIS Biome Reader")) {
            UUID uuid = player.getUniqueId();
            Biome biome = event.getClickedBlock().getBiome();
            if (biome.equals((Object)Biome.THE_VOID)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIOME_READER_NOT_VALID");
                return;
            }
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", uuid.toString());
            ResultSetDiskStorage rs = new ResultSetDiskStorage(this.plugin, where);
            if (rs.resultSet()) {
                try {
                    ItemStack[] disks1 = !rs.getBiomesOne().isEmpty() ? SerializeInventory.itemStacksFromString(rs.getBiomesOne()) : SerializeInventory.itemStacksFromString(Storage.BIOME_1.getEmpty());
                    String biomeKey = biome.getKey().getKey();
                    if (!TARDISBiomeReaderListener.hasBiomeDisk(disks1, biomeKey)) {
                        ItemStack[] disks2 = !rs.getBiomesOne().isEmpty() ? SerializeInventory.itemStacksFromString(rs.getBiomesTwo()) : SerializeInventory.itemStacksFromString(Storage.BIOME_2.getEmpty());
                        if (!TARDISBiomeReaderListener.hasBiomeDisk(disks2, biomeKey)) {
                            ItemStack bd = ItemStack.of((Material)Material.MUSIC_DISC_CAT, (int)1);
                            ItemMeta dim = bd.getItemMeta();
                            dim.displayName((Component)ComponentUtils.toWhite("Biome Storage Disk"));
                            ArrayList<TextComponent> disk_lore = new ArrayList<TextComponent>();
                            disk_lore.add(Component.text((String)biomeKey));
                            dim.lore(disk_lore);
                            bd.setItemMeta(dim);
                            int slot = this.getNextFreeSlot(disks1);
                            if (slot != -1) {
                                disks1[slot] = bd;
                                String serialized = SerializeInventory.itemStacksToString(disks1);
                                HashMap<String, Object> set = new HashMap<String, Object>();
                                set.put("biomes_one", serialized);
                                HashMap<String, Object> whereu = new HashMap<String, Object>();
                                whereu.put("uuid", uuid.toString());
                                this.plugin.getQueryFactory().doUpdate("storage", set, whereu);
                                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIOME_READER_ADDED", biomeKey, "1");
                            } else {
                                slot = this.getNextFreeSlot(disks2);
                                if (slot != -1) {
                                    disks2[slot] = bd;
                                    String serialized = SerializeInventory.itemStacksToString(disks2);
                                    HashMap<String, Object> set = new HashMap<String, Object>();
                                    set.put("biomes_two", serialized);
                                    HashMap<String, Object> whereu = new HashMap<String, Object>();
                                    whereu.put("uuid", uuid.toString());
                                    this.plugin.getQueryFactory().doUpdate("storage", set, whereu);
                                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIOME_READER_ADDED", biomeKey, "2");
                                } else {
                                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIOME_READER_FULL");
                                }
                            }
                        } else {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIOME_READER_FOUND", biomeKey, "2");
                        }
                    } else {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "BIOME_READER_FOUND", biomeKey, "1");
                    }
                }
                catch (IOException ex) {
                    this.plugin.debug("Could not get biome disks: " + String.valueOf(ex));
                }
            }
        }
    }

    private int getNextFreeSlot(ItemStack[] stack) {
        int slot = -1;
        for (int s = 27; s < stack.length; ++s) {
            ItemStack disk = stack[s];
            if (disk != null) continue;
            slot = s;
            break;
        }
        return slot;
    }
}

