/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.tool;

import com.formdev.flatlaf.FlatDarculaLaf;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.filechooser.FileNameExtensionFilter;
import me.eccentric_nz.TARDIS.database.tool.Main;

public class UserInterface
extends JFrame {
    private static final long serialVersionUID = 3259909191489626727L;
    private final PrintWriter consoleStream;
    private File lastDir = new File(".");
    private JButton convertButton;
    private JButton inputButton;
    private JTextField inputFile;
    private JLabel inputLabel;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JButton outputButton;
    private JTextArea outputConsole;
    private JTextField outputFile;
    private JLabel outputLabel;
    private JTextField prefix;
    private JLabel titleLabel;

    private UserInterface() {
        this.consoleStream = new PrintWriter((Writer)new StringWriter(){

            @Override
            public void flush() {
                UserInterface.this.outputConsole.append(this.getBuffer().toString());
                this.getBuffer().setLength(0);
            }
        }, true);
        this.initComponents();
    }

    public static void main(String[] args) {
        FlatDarculaLaf.setup();
        EventQueue.invokeLater(() -> new UserInterface().setVisible(true));
    }

    private void initComponents() {
        this.inputButton = new JButton();
        this.outputButton = new JButton();
        this.convertButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.outputConsole = new JTextArea();
        this.outputLabel = new JLabel();
        this.inputLabel = new JLabel();
        this.titleLabel = new JLabel();
        this.inputFile = new JTextField();
        this.outputFile = new JTextField();
        this.jLabel1 = new JLabel();
        this.prefix = new JTextField();
        this.setDefaultCloseOperation(3);
        this.inputButton.setText("Browse");
        this.inputButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                UserInterface.this.inputButtonMouseReleased(evt);
            }
        });
        this.outputButton.setText("Browse");
        this.outputButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                UserInterface.this.outputButtonMouseReleased(evt);
            }
        });
        this.convertButton.setText("Convert");
        this.convertButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                UserInterface.this.convertButtonMouseReleased(evt);
            }
        });
        this.outputConsole.setColumns(20);
        this.outputConsole.setRows(5);
        this.jScrollPane1.setViewportView(this.outputConsole);
        this.outputLabel.setText("Output file");
        this.inputLabel.setText("TARDIS.db");
        this.titleLabel.setText("TARDIS SQLite -> MySQL Database Converter");
        this.inputFile.addActionListener(this::inputFileActionPerformed);
        this.jLabel1.setText("Prefix");
        this.prefix.addActionListener(this::prefixActionPerformed);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.titleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 212, Short.MAX_VALUE).addComponent(this.convertButton)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outputLabel).addComponent(this.inputLabel).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outputFile).addComponent(this.inputFile).addComponent(this.prefix)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outputButton, GroupLayout.Alignment.TRAILING).addComponent(this.inputButton, GroupLayout.Alignment.TRAILING)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.inputButton).addComponent(this.inputLabel).addComponent(this.inputFile, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outputButton).addComponent(this.outputLabel).addComponent(this.outputFile, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.prefix, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jScrollPane1, -2, 253, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.convertButton).addComponent(this.titleLabel)).addContainerGap()));
        this.pack();
    }

    private void inputFileActionPerformed(ActionEvent evt) {
    }

    private void inputButtonMouseReleased(MouseEvent evt) {
        this.choose(this.inputFile, "SQLite Database", "db");
    }

    private void outputButtonMouseReleased(MouseEvent evt) {
        this.choose(this.outputFile, "SQL Text File", "sql");
    }

    private void convertButtonMouseReleased(MouseEvent evt) {
        try {
            this.convert();
        }
        catch (IOException ex) {
            Logger.getLogger(UserInterface.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void prefixActionPerformed(ActionEvent evt) {
    }

    private void choose(JTextField box, String description, String extension) {
        JFileChooser chooser = new JFileChooser(this.lastDir);
        chooser.setFileFilter(new FileNameExtensionFilter(description, extension));
        chooser.setFileSelectionMode(0);
        chooser.showOpenDialog(this);
        if (chooser.getSelectedFile() != null) {
            box.setText(chooser.getSelectedFile().getPath());
            this.lastDir = chooser.getCurrentDirectory();
        }
    }

    private void convert() throws IOException {
        if (this.inputFile.getText().isEmpty() || this.outputFile.getText().isEmpty()) {
            JOptionPane.showMessageDialog(this, "Please browse for TARDIS.db and TARDIS.sql files.", "Please select required files.", 0);
            return;
        }
        String pre = this.prefix.getText();
        Main.process(this.consoleStream, new File(this.inputFile.getText()), new File(this.outputFile.getText()), pre);
    }
}

