/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISBuilderInstanceKeeper;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class ResultSetTIPS {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;

    public ResultSetTIPS(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillUsedSlotList() {
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT tips FROM " + this.prefix + "tardis";
        try {
            statement = this.connection.createStatement();
            rs = statement.executeQuery(query);
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    int slot = rs.getInt("tips");
                    TARDISBuilderInstanceKeeper.getTipsSlots().add(slot);
                }
            }
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for tardis table (getting TIPS slots)! " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing tardis table (getting TIPS slots)! " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHightestSlot() {
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT MAX(tips) as highest FROM " + this.prefix + "tardis";
        try {
            statement = this.connection.createStatement();
            rs = statement.executeQuery(query);
            if (rs.isBeforeFirst()) {
                rs.next();
                int n = rs.getInt("highest");
                return n;
            }
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for tardis table (getting TIPS highest slot)! " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing tardis table (getting TIPS highest slot)! " + e.getMessage());
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSlot(int id) {
        PreparedStatement statement = null;
        ResultSet rs = null;
        String query = "SELECT tips FROM " + this.prefix + "tardis WHERE tardis_id = ?";
        try {
            statement = this.connection.prepareStatement(query);
            statement.setInt(1, id);
            rs = statement.executeQuery();
            if (rs.isBeforeFirst()) {
                rs.next();
                int n = rs.getInt("tips");
                return n;
            }
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for tardis table (getting TIPS slot)! " + e.getMessage());
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing tardis table (getting TIPS slot)! " + e.getMessage());
            }
        }
        return -1;
    }
}

