/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.data.Follower;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.monsters.ood.OodColour;
import me.eccentric_nz.tardisweepingangels.utils.Monster;

public class ResultSetRestoreFollowers {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private final List<Follower> followers = new ArrayList<Follower>();

    public ResultSetRestoreFollowers(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT * FROM " + this.prefix + "followers";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.createStatement();
            rs = statement.executeQuery(query);
            if (rs.isBeforeFirst()) {
                while (rs.next()) {
                    UUID owner = TARDISWeepingAngels.UNCLAIMED;
                    String o = rs.getString("owner");
                    if (!o.isEmpty()) {
                        owner = UUID.fromString(o);
                    }
                    OodColour colour = OodColour.BLACK;
                    String c = rs.getString("colour");
                    if (!c.isEmpty()) {
                        colour = OodColour.valueOf(c);
                    }
                    this.followers.add(new Follower(UUID.fromString(rs.getString("uuid")), owner, Monster.valueOf(rs.getString("species")), rs.getBoolean("following"), rs.getBoolean("option"), colour, rs.getInt("ammo")));
                }
                boolean owner = true;
                return owner;
            }
            boolean owner = false;
            return owner;
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for followers table! " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing followers table! " + e.getMessage());
            }
        }
    }

    public List<Follower> getFollowers() {
        return this.followers;
    }
}

