/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class ResultSetLibrary {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;
    private String location;

    public ResultSetLibrary(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fromLocation(String location) {
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT * FROM " + this.prefix + "vaults WHERE location = ? AND chest_type = 'LIBRARY'";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.prepareStatement(query);
            statement.setString(1, location);
            rs = statement.executeQuery();
            boolean bl = rs.isBeforeFirst();
            return bl;
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for [vaults] library table! " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing [vaults] library table! " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fromId(int id) {
        Statement statement = null;
        ResultSet rs = null;
        String query = "SELECT location FROM " + this.prefix + "vaults WHERE tardis_id = ? AND chest_type = 'LIBRARY'";
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.prepareStatement(query);
            statement.setInt(1, id);
            rs = statement.executeQuery();
            if (rs.isBeforeFirst()) {
                rs.next();
                this.location = rs.getString("location");
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            this.plugin.debug("ResultSet error for [vaults] library table! " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing [vaults] library table! " + e.getMessage());
            }
        }
        return false;
    }

    public String getLocation() {
        return this.location;
    }
}

