/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class ResultSetDestinations {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final HashMap<String, Object> where;
    private final boolean multiple;
    private final ArrayList<HashMap<String, String>> data = new ArrayList();
    private final String prefix;
    private int dest_id;
    private int tardis_id;
    private String dest_name;
    private String world;
    private int x;
    private int y;
    private int z;
    private String direction;
    private String preset;
    private boolean submarine;
    private int slot;

    public ResultSetDestinations(TARDIS plugin, HashMap<String, Object> where, boolean multiple) {
        this.plugin = plugin;
        this.where = where;
        this.multiple = multiple;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block24: {
            Statement statement = null;
            ResultSet rs = null;
            Object wheres = "";
            if (this.where != null) {
                StringBuilder sbw = new StringBuilder();
                this.where.forEach((key, value) -> sbw.append((String)key).append(" = ? AND "));
                wheres = " WHERE " + sbw.substring(0, sbw.length() - 5);
            }
            String query = "SELECT * FROM " + this.prefix + "destinations" + (String)wheres;
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                if (this.where != null) {
                    int s = 1;
                    for (Map.Entry<String, Object> entry : this.where.entrySet()) {
                        if (entry.getValue() instanceof String) {
                            statement.setString(s, entry.getValue().toString());
                        } else {
                            statement.setInt(s, (Integer)entry.getValue());
                        }
                        ++s;
                    }
                    this.where.clear();
                }
                if ((rs = statement.executeQuery()).isBeforeFirst()) {
                    while (rs.next()) {
                        if (this.multiple) {
                            HashMap<String, String> row = new HashMap<String, String>();
                            ResultSetMetaData rsmd = rs.getMetaData();
                            int columns = rsmd.getColumnCount();
                            for (int i = 1; i < columns + 1; ++i) {
                                row.put(rsmd.getColumnName(i).toLowerCase(Locale.ROOT), rs.getString(i));
                            }
                            this.data.add(row);
                        }
                        this.dest_id = rs.getInt("dest_id");
                        this.tardis_id = rs.getInt("tardis_id");
                        this.dest_name = rs.getString("dest_name");
                        this.world = rs.getString("world");
                        this.x = rs.getInt("x");
                        this.y = rs.getInt("y");
                        this.z = rs.getInt("z");
                        this.direction = rs.getString("direction");
                        this.preset = rs.getString("preset");
                        this.submarine = rs.getBoolean("submarine");
                        this.slot = rs.getInt("slot");
                    }
                    break block24;
                }
                boolean row = false;
                return row;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for destinations table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing destinations table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public int getDest_id() {
        return this.dest_id;
    }

    public String getDest_name() {
        return this.dest_name;
    }

    public String getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public String getDirection() {
        return this.direction;
    }

    public String getPreset() {
        return this.preset;
    }

    public boolean isSubmarine() {
        return this.submarine;
    }

    public ArrayList<HashMap<String, String>> getData() {
        return this.data;
    }
}

