/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.converters;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

public class LegacyConverter {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;

    public LegacyConverter(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOriginal() {
        Statement statement = null;
        Statement ps = null;
        String query = "SELECT tardis_id FROM " + this.prefix + "tardis WHERE `size` = 'LEGACY_BUDGET'";
        String update = "UPDATE " + this.prefix + "tardis SET size = 'ORIGINAL' WHERE tardis_id = ?";
        ResultSet rs = null;
        try {
            this.service.testConnection(this.connection);
            statement = this.connection.createStatement();
            rs = statement.executeQuery(query);
            if (rs.isBeforeFirst()) {
                ps = this.connection.prepareStatement(update);
                this.connection.setAutoCommit(false);
                while (rs.next()) {
                    ps.setInt(1, rs.getInt("tardis_id"));
                    ps.addBatch();
                }
                ps.executeBatch();
                this.connection.commit();
            }
        }
        catch (SQLException e) {
            this.plugin.debug("Update error for legacy budget! " + e.getMessage());
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
                if (rs != null) {
                    rs.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing legacy budget associated tables! " + e.getMessage());
            }
        }
    }
}

