/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.converters;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;

public class AbandonUpdate {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final int id;
    private final String uuid;
    private final String prefix;

    public AbandonUpdate(TARDIS plugin, int id, String uuid) {
        this.plugin = plugin;
        this.id = id;
        this.uuid = uuid;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Statement ps = null;
        try {
            this.service.testConnection(this.connection);
            String query = "UPDATE " + this.prefix + "tardis SET abandoned = 1, powered_on = 0, companions = '' WHERE tardis_id = ?";
            ps = this.connection.prepareStatement(query);
            ps.setInt(1, this.id);
            ps.executeUpdate();
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, this.id);
            if (rsc.resultSet()) {
                Current current = rsc.getCurrent();
                query = "UPDATE " + this.prefix + "back SET world = ?, x = ?, y = ?, z = ?, direction = ?, submarine = ? WHERE tardis_id = ?";
                ps = this.connection.prepareStatement(query);
                ps.setString(1, current.location().getWorld().getName());
                ps.setInt(2, current.location().getBlockX());
                ps.setInt(3, current.location().getBlockY());
                ps.setInt(4, current.location().getBlockZ());
                ps.setString(5, current.direction().toString());
                ps.setInt(6, current.submarine() ? 1 : 0);
                ps.setInt(7, this.id);
                ps.executeUpdate();
                query = "UPDATE " + this.prefix + "homes SET world = ?, x = ?, y = ?, z = ?, direction = ?, submarine = ? WHERE tardis_id = ?";
                ps = this.connection.prepareStatement(query);
                ps.setString(1, current.location().getWorld().getName());
                ps.setInt(2, current.location().getBlockX());
                ps.setInt(3, current.location().getBlockY());
                ps.setInt(4, current.location().getBlockZ());
                ps.setString(5, current.direction().toString());
                ps.setInt(6, current.submarine() ? 1 : 0);
                ps.setInt(7, this.id);
                ps.executeUpdate();
            }
            query = "DELETE FROM " + this.prefix + "destinations WHERE tardis_id = ?";
            ps = this.connection.prepareStatement(query);
            ps.setInt(1, this.id);
            ps.executeUpdate();
            query = "DELETE FROM " + this.prefix + "junk WHERE tardis_id = ?";
            ps = this.connection.prepareStatement(query);
            ps.setInt(1, this.id);
            ps.executeUpdate();
            query = "UPDATE " + this.prefix + "storage SET tardis_id = '-1' WHERE tardis_id = ?";
            ps = this.connection.prepareStatement(query);
            ps.setInt(1, this.id);
            ps.executeUpdate();
            if (this.plugin.getConfig().getInt("creation.count") > 0 && this.plugin.getConfig().getBoolean("abandon.reduce_count")) {
                query = "UPDATE " + this.prefix + "t_count SET count = (count - 1) WHERE uuid = ?";
                ps = this.connection.prepareStatement(query);
                ps.setString(1, this.uuid);
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            this.plugin.debug("Update error for abandon! " + e.getMessage());
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing abandon associated tables! " + e.getMessage());
            }
        }
    }
}

