/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;

class TARDISSQLInsert
implements Runnable {
    private final TARDIS plugin;
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final String table;
    private final HashMap<String, Object> data;
    private final String prefix;

    TARDISSQLInsert(TARDIS plugin, String table, HashMap<String, Object> data) {
        this.plugin = plugin;
        this.table = table;
        this.data = data;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Statement ps = null;
        StringBuilder sbf = new StringBuilder();
        StringBuilder sbq = new StringBuilder();
        this.data.forEach((key, value) -> {
            sbf.append((String)key).append(",");
            sbq.append("?,");
        });
        String fields = sbf.substring(0, sbf.length() - 1);
        String questions = sbq.substring(0, sbq.length() - 1);
        try {
            this.service.testConnection(this.connection);
            ps = this.connection.prepareStatement("INSERT INTO " + this.prefix + this.table + " (" + fields + ") VALUES (" + questions + ")");
            int i = 1;
            for (Map.Entry<String, Object> entry : this.data.entrySet()) {
                if (entry.getValue() instanceof String || entry.getValue() instanceof UUID) {
                    ps.setString(i, entry.getValue().toString());
                } else if (entry.getValue() instanceof Integer) {
                    ps.setInt(i, (Integer)entry.getValue());
                } else if (entry.getValue() instanceof Double) {
                    ps.setDouble(i, (Double)entry.getValue());
                } else if (entry.getValue() instanceof Float) {
                    ps.setFloat(i, ((Float)entry.getValue()).floatValue());
                } else if (entry.getValue() instanceof Long) {
                    ps.setLong(i, (Long)entry.getValue());
                }
                ++i;
            }
            this.data.clear();
            ps.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.debug("Insert error for " + this.table + "! " + e.getMessage());
        }
        finally {
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException e) {
                this.plugin.debug("Error closing " + this.table + "! " + e.getMessage());
            }
        }
    }
}

