/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.control.actions;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.event.TARDISZeroRoomEnterEvent;
import me.eccentric_nz.TARDIS.api.event.TARDISZeroRoomExitEvent;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.rooms.ExteriorRenderer;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class ZeroRoomAction {
    private final TARDIS plugin;

    public ZeroRoomAction(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void doEntry(Player player, Tardis tardis, int id) {
        int zero_amount = this.plugin.getArtronConfig().getInt("zero");
        if (tardis.getArtronLevel() < zero_amount) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_ENOUGH_ZERO_ENERGY");
            return;
        }
        Location zero = TARDISStaticLocationGetters.getLocationFromDB(tardis.getZero());
        if (zero != null) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ZERO_READY");
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                new ExteriorRenderer(this.plugin).transmat(player, COMPASS.SOUTH, zero);
                this.plugin.getPM().callEvent((Event)new TARDISZeroRoomEnterEvent(player, id));
            }, 20L);
            this.plugin.getTrackerKeeper().getZeroRoomOccupants().add(player.getUniqueId());
            HashMap<String, Object> wherez = new HashMap<String, Object>();
            wherez.put("tardis_id", id);
            this.plugin.getQueryFactory().alterEnergyLevel("tardis", -zero_amount, wherez, player);
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_ZERO");
        }
    }

    public void doExit(Player player, int id) {
        this.plugin.getTrackerKeeper().getZeroRoomOccupants().remove(player.getUniqueId());
        this.plugin.getGeneralKeeper().getRendererListener().transmat(player);
        this.plugin.getPM().callEvent((Event)new TARDISZeroRoomExitEvent(player, id));
    }
}

