/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.travel;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.CircuitChecker;
import me.eccentric_nz.TARDIS.advanced.CircuitDamager;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.api.event.TARDISTravelEvent;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDestinations;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.DiskCircuit;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.flight.TARDISLand;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.travel.TARDISAreaCheck;
import me.eccentric_nz.TARDIS.travel.TravelCostAndType;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class SaveCommand {
    private final TARDIS plugin;

    public SaveCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean action(Player player, String[] args, int id, ChameleonPreset preset) {
        if (TARDISPermission.hasPermission(player, "tardis.save")) {
            World w;
            if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(player.getUniqueId().toString(), SystemTree.SAVES)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Saves");
                return true;
            }
            HashMap<String, Object> whered = new HashMap<String, Object>();
            whered.put("dest_name", args[1]);
            whered.put("tardis_id", id);
            ResultSetDestinations rsd = new ResultSetDestinations(this.plugin, whered, false);
            if (!rsd.resultSet()) {
                this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "SAVE_NOT_FOUND", "/tardis list saves", this.plugin);
                return true;
            }
            CircuitChecker tcc = new CircuitChecker(this.plugin, id);
            tcc.getCircuits();
            if (this.plugin.getConfig().getBoolean("difficulty.circuits") && !this.plugin.getUtils().inGracePeriod(player, false) && !tcc.hasMemory()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_MEM_CIRCUIT");
                return true;
            }
            if (this.plugin.getConfig().getBoolean("circuits.damage") && this.plugin.getConfig().getInt("circuits.uses.memory") > 0) {
                int uses_left = tcc.getMaterialisationUses();
                new CircuitDamager(this.plugin, DiskCircuit.MEMORY, uses_left, id, player).damage();
            }
            if ((w = TARDISAliasResolver.getWorldFromAlias(rsd.getWorld())) != null) {
                TARDISAreaCheck tac;
                if (w.getName().startsWith("TARDIS_")) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SAVE_NO_TARDIS");
                    return true;
                }
                Location save_dest = new Location(w, (double)rsd.getX(), (double)rsd.getY(), (double)rsd.getZ());
                if (!this.plugin.getPluginRespect().getRespect(save_dest, new Parameters(player, Flag.getDefaultFlags()))) {
                    if (this.plugin.getConfig().getBoolean("travel.no_destination_malfunctions")) {
                        this.plugin.getTrackerKeeper().getMalfunction().put(id, true);
                    } else {
                        return true;
                    }
                }
                if ((tac = this.plugin.getTardisArea().isSaveInArea(save_dest)).isInArea()) {
                    HashMap<String, Object> wheres = new HashMap<String, Object>();
                    wheres.put("world", rsd.getWorld());
                    wheres.put("x", rsd.getX());
                    wheres.put("y", rsd.getY());
                    wheres.put("z", rsd.getZ());
                    ResultSetCurrentLocation rsz = new ResultSetCurrentLocation(this.plugin, wheres);
                    if (rsz.resultSet()) {
                        this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "TARDIS_IN_SPOT", "/tardistravel area [name]", this.plugin);
                        return true;
                    }
                    String invisibility = tac.getArea().invisibility();
                    if (invisibility.equals("DENY") && preset.equals((Object)ChameleonPreset.INVISIBLE)) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_NO_INVISIBLE");
                        return true;
                    }
                    if (!invisibility.equals("ALLOW")) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AREA_FORCE_PRESET", invisibility);
                        HashMap<String, Object> wherei = new HashMap<String, Object>();
                        wherei.put("tardis_id", id);
                        HashMap<String, Object> seti = new HashMap<String, Object>();
                        seti.put("chameleon_preset", invisibility);
                        seti.put("adapti_on", 0);
                        this.plugin.getQueryFactory().doSyncUpdate("tardis", seti, wherei);
                    }
                }
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("world", rsd.getWorld());
                set.put("x", rsd.getX());
                set.put("y", rsd.getY());
                set.put("z", rsd.getZ());
                if (!rsd.getDirection().isEmpty() && rsd.getDirection().length() < 6) {
                    set.put("direction", rsd.getDirection());
                } else {
                    ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                    if (!rsc.resultSet()) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CURRENT_NOT_FOUND");
                        return true;
                    }
                    set.put("direction", rsc.getCurrent().direction().toString());
                }
                set.put("submarine", rsd.isSubmarine() ? 1 : 0);
                if (!rsd.getPreset().isEmpty()) {
                    HashMap<String, Object> seti = new HashMap<String, Object>();
                    seti.put("chameleon_preset", rsd.getPreset());
                    seti.put("adapti_on", 0);
                    HashMap<String, Object> wherei = new HashMap<String, Object>();
                    wherei.put("tardis_id", id);
                    this.plugin.getQueryFactory().doSyncUpdate("tardis", seti, wherei);
                }
                HashMap<String, Object> tid = new HashMap<String, Object>();
                tid.put("tardis_id", id);
                this.plugin.getQueryFactory().doSyncUpdate("next", set, tid);
                this.plugin.getMessenger().send(player, "LOC_SET", !this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id));
                this.plugin.getTrackerKeeper().getHasDestination().put(id, new TravelCostAndType(this.plugin.getArtronConfig().getInt("travel"), TravelType.SAVE));
                this.plugin.getTrackerKeeper().getRescue().remove(id);
                if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                    new TARDISLand(this.plugin, id, player).exitVortex();
                    this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, TravelType.SAVE, id));
                }
            } else {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SAVE_NO_WORLD");
            }
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TRAVEL_NO_PERM_SAVE");
        }
        return true;
    }
}

