/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.dev.lists;

import java.util.Locale;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemRegistry;
import me.eccentric_nz.TARDIS.customblocks.TARDISSeedDisplayItem;
import me.eccentric_nz.TARDIS.enumeration.RecipeCategory;
import me.eccentric_nz.TARDIS.enumeration.RecipeItem;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import org.bukkit.NamespacedKey;
import org.bukkit.command.CommandSender;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class RecipesLister {
    private final TARDIS plugin;

    public RecipesLister(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void listRecipes(CommandSender sender, String[] args) {
        block12: {
            block11: {
                if (args.length <= 2) break block11;
                for (RecipeCategory category : RecipeCategory.values()) {
                    if (category == RecipeCategory.UNUSED || category == RecipeCategory.UNCRAFTABLE) continue;
                    sender.sendMessage("#### " + category.getName());
                    for (RecipeItem item : RecipeItem.values()) {
                        if (item.getCategory() != category) continue;
                        sender.sendMessage("| " + TARDISStringUtils.capitalise(item.name()) + " | `/tardisrecipe " + item.toTabCompletionString() + "` |");
                    }
                    this.plugin.getMessenger().message(sender, "");
                }
                break block12;
            }
            for (Map.Entry<String, ShapedRecipe> entry : this.plugin.getFigura().getShapedRecipes().entrySet()) {
                sender.sendMessage(TARDISStringUtils.toUnderscoredUppercase(entry.getKey()) + "(\"" + entry.getKey() + "\", Material." + String.valueOf(entry.getValue().getResult().getType()) + ", " + String.valueOf(RecipeItem.getByName(entry.getKey()).getModel()) + "),");
            }
            for (Map.Entry<String, ShapedRecipe> entry : this.plugin.getIncomposita().getShapelessRecipes().entrySet()) {
                sender.sendMessage(TARDISStringUtils.toUnderscoredUppercase(entry.getKey()) + "(\"" + entry.getKey() + "\", Material." + String.valueOf(((ShapelessRecipe)entry.getValue()).getResult().getType()) + ", " + String.valueOf(RecipeItem.getByName(entry.getKey()).getModel()) + "),");
            }
            if (this.plugin.getConfig().getBoolean("creation.seed_block.crafting")) {
                for (Map.Entry entry : this.plugin.getObstructionum().getSeedRecipes().entrySet()) {
                    String material;
                    NamespacedKey model = TARDISSeedDisplayItem.CUSTOM.getCustomModel();
                    if (((Schematic)entry.getKey()).isCustom()) {
                        material = ((Schematic)entry.getKey()).getSeedMaterial().toString();
                    } else {
                        try {
                            TARDISDisplayItem tdi = TARDISDisplayItemRegistry.valueOf(((Schematic)entry.getKey()).getPermission().toUpperCase(Locale.ROOT));
                            model = tdi.getCustomModel();
                            material = tdi.getMaterial().toString();
                        }
                        catch (IllegalArgumentException e) {
                            material = TARDISSeedDisplayItem.CUSTOM.getMaterial().toString();
                        }
                    }
                    sender.sendMessage(((Schematic)entry.getKey()).getPermission().toUpperCase(Locale.ROOT) + "_SEED(\"" + ((Schematic)entry.getKey()).getPermission() + "\", Material." + material + ", " + String.valueOf(model) + "),");
                }
            }
            if (!this.plugin.getConfig().getBoolean("modules.weeping_angels")) break block12;
            for (Monster m : Monster.values()) {
                sender.sendMessage(m.toString() + "_HEAD(\"" + m.getName() + " Head\", Material." + m.getMaterial().toString() + ", " + String.valueOf(m.getModel()) + "),");
            }
        }
    }
}

