/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.admin;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.BlueprintType;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.Desktops;
import me.eccentric_nz.TARDIS.rooms.TARDISWalls;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Creature;
import org.bukkit.entity.EntityType;
import org.bukkit.permissions.Permission;

public class TARDISAdminTabComplete
extends TARDISCompleter
implements TabCompleter {
    private final ImmutableList<String> ROOT_SUBS = ImmutableList.of((Object)"add_regions", (Object)"arch", (Object)"assemble", (Object)"clean", (Object)"condenser", (Object)"config", (Object)"convert_database", (Object)"create", (Object)"decharge", (Object)"delete", (Object)"disguise", (Object)"dispersed", (Object[])new String[]{"enter", "find", "list", "make_preset", "maze", "mvimport", "playercount", "prune", "prunelist", "purge", "purge_portals", "recharger", "region_flag", "reload", "repair", "revoke", "set_size", "spawn_abandoned", "undisguise", "update_plugin"});
    private final ImmutableList<String> ASS_SUBS = ImmutableList.of((Object)"clear", (Object)"list");
    private final ImmutableList<String> COMPASS_SUBS = ImmutableList.of((Object)"NORTH", (Object)"EAST", (Object)"SOUTH", (Object)"WEST");
    private final ImmutableList<String> ENTITY_SUBS;
    private final ImmutableList<String> LIST_SUBS = ImmutableList.of((Object)"abandoned", (Object)"portals", (Object)"save", (Object)"preset_perms", (Object)"perms", (Object)"recipes", (Object)"blueprints");
    private final ImmutableList<String> PRESETS;
    private final ImmutableList<String> SEED_SUBS = ImmutableList.copyOf(Desktops.getBY_NAMES().keySet());
    private final ImmutableList<String> WORLD_SUBS;
    private final List<String> BLUEPRINT_SUBS = new ArrayList<String>();
    private final List<String> BLUEPRINT_TYPE_SUBS = new ArrayList<String>();
    private final List<String> MAT_SUBS = new ArrayList<String>();

    public TARDISAdminTabComplete(TARDIS plugin) {
        ArrayList<String> tmpPresets = new ArrayList<String>();
        for (ChameleonPreset p : ChameleonPreset.values()) {
            tmpPresets.add(p.toString());
        }
        this.PRESETS = ImmutableList.copyOf(tmpPresets);
        ArrayList worlds = new ArrayList();
        plugin.getServer().getWorlds().forEach(w -> worlds.add(w.getName()));
        this.WORLD_SUBS = ImmutableList.copyOf(worlds);
        ArrayList<String> tmpEntities = new ArrayList<String>();
        for (EntityType e : EntityType.values()) {
            if (e.getEntityClass() == null || !Creature.class.isAssignableFrom(e.getEntityClass())) continue;
            tmpEntities.add(e.toString());
        }
        this.ENTITY_SUBS = ImmutableList.copyOf(tmpEntities);
        for (Permission b : plugin.getDescription().getPermissions()) {
            this.BLUEPRINT_SUBS.add(b.getName());
        }
        for (BlueprintType type : BlueprintType.values()) {
            this.BLUEPRINT_TYPE_SUBS.add(type.toString());
        }
        TARDISWalls.BLOCKS.forEach(m -> this.MAT_SUBS.add(m.toString()));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        String lastArg = args[args.length - 1];
        if (args.length == 1) {
            return this.partial(args[0], (Collection<String>)this.ROOT_SUBS);
        }
        if (args.length == 2) {
            String sub;
            switch (sub = args[0].toLowerCase(Locale.ROOT)) {
                case "assemble": 
                case "dispersed": {
                    return this.partial(lastArg, (Collection<String>)this.ASS_SUBS);
                }
                case "disguise": {
                    return this.partial(lastArg, (Collection<String>)this.ENTITY_SUBS);
                }
                case "list": {
                    return this.partial(lastArg, (Collection<String>)this.LIST_SUBS);
                }
            }
            return null;
        }
        if (args.length == 3) {
            if (args[0].equalsIgnoreCase("spawn_abandoned")) {
                return this.partial(lastArg, (Collection<String>)this.PRESETS);
            }
            if (args[0].equalsIgnoreCase("create") || args[0].equalsIgnoreCase("set_size")) {
                return this.partial(lastArg, (Collection<String>)this.SEED_SUBS);
            }
            if (args[0].equalsIgnoreCase("disguise")) {
                return null;
            }
            if (args[0].equalsIgnoreCase("revoke")) {
                return this.partial(lastArg, this.BLUEPRINT_SUBS);
            }
            if (args[0].equalsIgnoreCase("list") && args[1].equalsIgnoreCase("blueprints")) {
                return this.partial(lastArg, this.BLUEPRINT_TYPE_SUBS);
            }
        } else {
            if (args.length == 4) {
                if (args[0].equalsIgnoreCase("create")) {
                    return this.partial(lastArg, this.MAT_SUBS);
                }
                return this.partial(lastArg, (Collection<String>)this.COMPASS_SUBS);
            }
            if (args.length == 5) {
                if (args[0].equalsIgnoreCase("create")) {
                    return this.partial(lastArg, this.MAT_SUBS);
                }
                return this.partial(lastArg, (Collection<String>)this.WORLD_SUBS);
            }
        }
        return ImmutableList.of();
    }
}

