/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.builders.interior;

import java.util.HashMap;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.event.TARDISCreationEvent;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.builders.exterior.MaterialiseBlockPreset;
import me.eccentric_nz.TARDIS.builders.exterior.MaterialiseModelledPreset;
import me.eccentric_nz.TARDIS.builders.interior.AbandonedBuildRunnable;
import me.eccentric_nz.TARDIS.enumeration.Adaption;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class AbandonedBuilder {
    private final TARDIS plugin;

    public AbandonedBuilder(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void spawn(Location l, Schematic schm, ChameleonPreset preset, String item, COMPASS d, Player player) {
        Chunk chunk = l.getChunk();
        String cw = this.plugin.getConfig().getString("creation.default_world_name");
        World chunkworld = TARDISAliasResolver.getWorldFromAlias(cw);
        int cx = chunk.getX();
        int cz = chunk.getZ();
        String chun = cw + ":" + cx + ":" + cz;
        HashMap<String, Object> set = new HashMap<String, Object>();
        set.put("uuid", UUID.randomUUID().toString());
        set.put("owner", "");
        set.put("chunk", chun);
        set.put("size", schm.getPermission().toUpperCase(Locale.ROOT));
        set.put("abandoned", 1);
        set.put("powered_on", 0);
        set.put("lastuse", Long.MAX_VALUE);
        if (preset == ChameleonPreset.ITEM) {
            set.put("chameleon_preset", "ITEM:" + item);
            set.put("chameleon_demat", "ITEM:" + item);
        } else {
            set.put("chameleon_preset", preset.toString());
            set.put("chameleon_demat", preset.toString());
        }
        int lastInsertId = this.plugin.getQueryFactory().doSyncInsert("tardis", set);
        HashMap<String, Object> setlocs = new HashMap<String, Object>();
        setlocs.put("tardis_id", lastInsertId);
        setlocs.put("world", l.getWorld().getName());
        setlocs.put("x", l.getBlockX());
        setlocs.put("y", l.getBlockY());
        setlocs.put("z", l.getBlockZ());
        setlocs.put("direction", d.toString());
        this.plugin.getQueryFactory().insertLocations(setlocs);
        BuildData bd = new BuildData(null);
        bd.setDirection(d);
        bd.setLocation(l);
        bd.setMalfunction(false);
        bd.setOutside(true);
        bd.setRebuild(false);
        bd.setSubmarine(l.getBlock().getType().equals((Object)Material.WATER));
        bd.setTardisID(lastInsertId);
        bd.setPlayer((OfflinePlayer)player);
        bd.setThrottle(SpaceTimeThrottle.REBUILD);
        this.plugin.getPM().callEvent((Event)new TARDISCreationEvent(null, lastInsertId, l));
        AbandonedBuildRunnable builder = new AbandonedBuildRunnable(this.plugin, schm, chunkworld, lastInsertId, player);
        int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)builder, 1L, 3L);
        builder.setTask(task);
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            this.plugin.getTrackerKeeper().getMaterialising().add(bd.getTardisID());
            if (preset.usesArmourStand()) {
                MaterialiseModelledPreset runnable = new MaterialiseModelledPreset(this.plugin, bd, preset);
                int taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, 10L, 20L);
                runnable.setTask(taskID);
            } else {
                BlockData data = preset.equals((Object)ChameleonPreset.FACTORY) ? Material.LIGHT_GRAY_TERRACOTTA.createBlockData() : Material.BLUE_WOOL.createBlockData();
                MaterialiseBlockPreset runnable = new MaterialiseBlockPreset(this.plugin, bd, preset, data, Adaption.OFF);
                int taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, 10L, 20L);
                runnable.setTask(taskID);
            }
            TARDISSounds.playTARDISSound(bd.getLocation(), "tardis_land_fast");
        }, schm.getConsoleSize().getDelay());
    }
}

